/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.connect.server;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.capedwarf.connect.config.Configuration;
import org.jboss.capedwarf.connect.server.ServerProxyHandle;
import org.jboss.capedwarf.connect.server.ServerProxyHandler;
import org.jboss.capedwarf.connect.server.ServerProxyInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerProxyFactory {
    private static Map<Class<?>, ServerProxyHandle> instances = new WeakHashMap();

    public static synchronized <T> T create(Class<T> proxyClass) {
        ServerProxyHandle instance = instances.get(proxyClass);
        if (instance == null) {
            Configuration<T> config = Configuration.getInstance();
            config.setProxyClass(proxyClass);
            instance = ServerProxyFactory.create(config);
            instances.put(proxyClass, instance);
        }
        return (T)instance;
    }

    public static <T> T create(Configuration<T> config) {
        return ServerProxyFactory.create(new ServerProxyHandler(config), config.getProxyClass());
    }

    public static <T> T create(ServerProxyInvocationHandler handler, Class<T> proxyClass) {
        Object proxy = Proxy.newProxyInstance(ServerProxyHandle.class.getClassLoader(), new Class[]{ServerProxyHandle.class, proxyClass}, (InvocationHandler)handler);
        return proxyClass.cast(proxy);
    }

    public static synchronized void shutdown(Class<?> proxyClass) {
        ServerProxyHandle handle = instances.remove(proxyClass);
        if (handle != null) {
            handle.shutdown();
        }
    }
}

