/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.connect.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.validation.constraints.Size;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.jboss.capedwarf.common.env.Environment;
import org.jboss.capedwarf.common.env.EnvironmentFactory;
import org.jboss.capedwarf.common.env.Secure;
import org.jboss.capedwarf.common.io.ClosedInputStream;
import org.jboss.capedwarf.common.serialization.BufferedSerializator;
import org.jboss.capedwarf.common.serialization.ConverterUtils;
import org.jboss.capedwarf.common.serialization.ElementTypeProvider;
import org.jboss.capedwarf.common.serialization.GzipOptionalSerializator;
import org.jboss.capedwarf.common.serialization.JSONAware;
import org.jboss.capedwarf.common.serialization.JSONAwareInstanceProvider;
import org.jboss.capedwarf.common.serialization.JSONCollectionSerializator;
import org.jboss.capedwarf.common.serialization.JSONSerializator;
import org.jboss.capedwarf.common.serialization.MultiJSONCollectionSerializator;
import org.jboss.capedwarf.common.serialization.ReflectionJSONAwareInstanceProvider;
import org.jboss.capedwarf.common.serialization.Serializator;
import org.jboss.capedwarf.connect.config.Configuration;
import org.jboss.capedwarf.connect.server.CommaListedFormattable;
import org.jboss.capedwarf.connect.server.Query;
import org.jboss.capedwarf.connect.server.QueryParameter;
import org.jboss.capedwarf.connect.server.ServerProxyHandle;
import org.jboss.capedwarf.connect.server.ServerProxyInvocationHandler;
import org.jboss.capedwarf.validation.ValidationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerProxyHandler
implements ServerProxyInvocationHandler {
    private HttpClient client;
    private Map<String, QueryInfo> queryCache = new HashMap<String, QueryInfo>();
    private volatile Environment env;
    private String endpointUrl;
    private Configuration config;
    private boolean allowsStreaming;

    public ServerProxyHandler(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("Null configuration");
        }
        this.endpointUrl = config.getHostName();
        int pos = this.endpointUrl.indexOf("://");
        if (pos != -1) {
            if (pos > 0) {
                this.endpointUrl = this.endpointUrl.substring(pos);
            }
        } else if (pos == -1) {
            this.endpointUrl = "://" + this.endpointUrl;
        }
        if (!this.endpointUrl.endsWith("/")) {
            this.endpointUrl = this.endpointUrl + "/";
        }
        this.endpointUrl = this.endpointUrl + "client/";
        this.config = config;
    }

    @Override
    public void setAllowsStreaming(boolean allowsStreaming) {
        this.allowsStreaming = allowsStreaming;
    }

    private synchronized HttpClient getClient() {
        if (this.client == null) {
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)30000);
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), this.config.getPort()));
            schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), this.config.getSslPort()));
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
            this.client = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
        }
        return this.client;
    }

    @Override
    public synchronized void shutdown() {
        if (this.client != null) {
            HttpClient tmp = this.client;
            this.client = null;
            ClientConnectionManager manager = tmp.getConnectionManager();
            if (manager != null) {
                manager.shutdown();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
        ResultProducer rp;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Object.class) {
            return null;
        }
        if (ServerProxyHandle.class.equals(declaringClass)) {
            if ("setAllowsStreaming".equals(method.getName())) {
                this.setAllowsStreaming((Boolean)args[0]);
                return null;
            } else {
                if (!"shutdown".equals(method.getName())) return null;
                this.shutdown();
            }
            return null;
        }
        final QueryInfo query = this.createQuery(method, args);
        if (query.jsonAware) {
            final ArrayList toJSON = new ArrayList();
            for (Object arg : args) {
                if (!JSONAware.class.isInstance(arg)) continue;
                ValidationHelper.validate((Object)arg);
                toJSON.add(JSONAware.class.cast(arg));
            }
            rp = new ResultProducer(){

                public Result run() throws Throwable {
                    return ServerProxyHandler.this.getContent(query, toJSON);
                }
            };
        } else if (query.directContent) {
            if (args[0] instanceof ContentProducer) {
                rp = new ResultProducer(){

                    public Result run() throws Throwable {
                        return ServerProxyHandler.this.getResultWithContentProducer(query, (ContentProducer)args[0]);
                    }
                };
            } else {
                if (!(args[0] instanceof HttpEntity)) throw new IllegalArgumentException("Cannot create ResultProducer, illegal argument: " + Arrays.toString(args));
                rp = new ResultProducer(){

                    public Result run() throws Throwable {
                        return ServerProxyHandler.this.getResultWithHttpEntity(query, (HttpEntity)args[0]);
                    }
                };
            }
        } else {
            rp = new ResultProducer(){

                public Result run() throws Throwable {
                    return ServerProxyHandler.this.getResultWithHttpEntity(query, null);
                }
            };
        }
        Result result = this.wrapResult(rp.run());
        InputStream content = result.stream;
        try {
            if (result.status == 200) return this.toValue(method, content);
            this.packResponseError(method, content, result.status);
            return this.toValue(method, content);
        }
        catch (Throwable t) {
            if (result.executionTime <= 29000L) throw t;
            this.getEnv().log("", Level.CONFIG, "Retrying, hit GAE limit: " + result.executionTime / 1000L, null);
            result = this.wrapResult(rp.run());
            if (result.status == 200) return this.toValue(method, result.stream);
            this.packResponseError(method, result.stream, result.status);
            return this.toValue(method, result.stream);
        }
    }

    protected Result wrapResult(Result result) {
        return result;
    }

    protected Environment getEnv() {
        if (this.env == null) {
            this.env = EnvironmentFactory.getEnvironment();
        }
        return this.env;
    }

    protected Result getContent(QueryInfo qi, final List<JSONAware> args) throws Throwable {
        ContentProducer cp = null;
        if (qi.jsonAware && !args.isEmpty()) {
            cp = new ContentProducer(){

                public void writeTo(OutputStream outputStream) throws IOException {
                    if (args.size() == 1) {
                        Serializator serializator = ServerProxyHandler.this.config.isDebugLogging() ? JSONSerializator.OPTIONAL_GZIP_BUFFERED : JSONSerializator.OPTIONAL_GZIP;
                        serializator.serialize(args.get(0), outputStream);
                    } else {
                        GzipOptionalSerializator serializator = new GzipOptionalSerializator((Serializator)new MultiJSONCollectionSerializator((JSONAwareInstanceProvider)new ReflectionJSONAwareInstanceProvider(new ElementTypeProvider(){

                            public Class getType(int index) {
                                return ((JSONAware)args.get(index)).getClass();
                            }
                        })));
                        serializator.serialize((Object)args, outputStream);
                    }
                    outputStream.flush();
                }
            };
        }
        return this.getResultWithContentProducer(qi, cp);
    }

    protected Result getResultWithContentProducer(QueryInfo qi, ContentProducer cp) throws Throwable {
        EntityTemplate entity = null;
        if (cp != null) {
            if (this.allowsStreaming) {
                entity = new EntityTemplate(cp);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                cp.writeTo((OutputStream)baos);
                entity = new ByteArrayEntity(baos.toByteArray());
            }
        }
        return this.getResultWithHttpEntity(qi, (HttpEntity)entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result getResultWithHttpEntity(QueryInfo qi, HttpEntity entity) throws Throwable {
        String link = "http" + (this.getSecure(qi) ? "s" : "") + this.endpointUrl + (qi.secure ? "secure/" : "") + qi.query;
        if (this.config.isDebugLogging()) {
            this.getEnv().log("", Level.INFO, "URL: " + link, null);
        }
        HttpPost httppost = new HttpPost(link);
        if (entity != null) {
            httppost.setEntity(entity);
        }
        if (qi.secure) {
            Environment env = EnvironmentFactory.getEnvironment();
            long id = env.getUserId();
            String token = env.getUserToken();
            httppost.addHeader("client_id", String.valueOf(id));
            httppost.addHeader("client_token", token);
        }
        if (GzipOptionalSerializator.isGzipDisabled()) {
            httppost.addHeader("Ignore-GZIP", Boolean.TRUE.toString());
        }
        Result result = new Result();
        try {
            HttpResponse response = this.getClient().execute((HttpUriRequest)httppost);
            result.status = response.getStatusLine().getStatusCode();
            result.stream = response.getEntity().getContent();
        }
        finally {
            result.end();
        }
        return result;
    }

    private boolean getSecure(QueryInfo qi) {
        return !this.config.isDebugMode() && qi.secure;
    }

    protected QueryInfo createQuery(Method method, Object[] args) {
        QueryInfo value;
        Query query = method.getAnnotation(Query.class);
        if (query != null) {
            value = new QueryInfo();
            value.query = query.value();
            value.jsonAware = query.jsonAware();
            value.secure = method.isAnnotationPresent(Secure.class);
        } else {
            String methodName = method.getName();
            Object[] pt = method.getParameterTypes();
            boolean[] notNullChecks = new boolean[pt.length];
            for (int i = 0; i < pt.length; ++i) {
                boolean bl = notNullChecks[i] = args[i] != null;
                if (!notNullChecks[i] || !(args[i] instanceof Enum)) continue;
                Enum e = (Enum)args[i];
                args[i] = e.ordinal();
            }
            String key = methodName + Arrays.toString(pt);
            value = this.queryCache.get(key);
            if (value == null) {
                char[] chars;
                boolean type = false;
                boolean jsonAware = false;
                boolean directContent = false;
                StringBuilder builder = new StringBuilder();
                for (char ch : chars = methodName.toCharArray()) {
                    if (Character.isUpperCase(ch)) {
                        if (type) {
                            builder.append('-');
                        } else {
                            type = true;
                            builder.append("?action=");
                        }
                    }
                    builder.append(Character.toLowerCase(ch));
                }
                Annotation[][] pa = method.getParameterAnnotations();
                for (int i = 0; i < pt.length; ++i) {
                    Annotation[] ppa = pa[i];
                    if (ppa == null || ppa.length == 0) {
                        if (!notNullChecks[i]) {
                            throw new IllegalArgumentException("Null non-query (JSON, ...) aware parameter: " + i);
                        }
                        if (!JSONAware.class.isAssignableFrom((Class<?>)pt[i])) {
                            if (ContentProducer.class.isAssignableFrom((Class<?>)pt[i]) || HttpEntity.class.isAssignableFrom((Class<?>)pt[i])) {
                                if (pt.length > 1) {
                                    throw new IllegalArgumentException("Only 1 non-JSONAware argument allowed: " + Arrays.toString(pt));
                                }
                                directContent = true;
                            } else {
                                throw new IllegalArgumentException("Illegal method parameter, missing QueryParameter? - " + method);
                            }
                        }
                        jsonAware = jsonAware || JSONAware.class.isAssignableFrom((Class<?>)pt[i]);
                        continue;
                    }
                    for (Annotation a : ppa) {
                        if (a instanceof QueryParameter) {
                            QueryParameter qp = (QueryParameter)a;
                            if (!notNullChecks[i] && qp.required()) {
                                throw new IllegalArgumentException("Argument is required, but it's null: " + qp.value());
                            }
                            if (!notNullChecks[i]) continue;
                            builder.append("&").append(qp.value()).append("=").append("%").append(i + 1).append("$1s");
                            continue;
                        }
                        if (!(a instanceof Size)) continue;
                        Size size = (Size)a;
                        ValidationHelper.validate((Size)size, (Object)args[i]);
                    }
                    if (!notNullChecks[i] || !(args[i] instanceof Iterable)) continue;
                    args[i] = new CommaListedFormattable((Iterable)args[i]);
                }
                value = new QueryInfo();
                value.query = builder.toString();
                value.jsonAware = jsonAware;
                value.directContent = directContent;
                value.secure = method.isAnnotationPresent(Secure.class);
                this.queryCache.put(key, value);
            }
        }
        QueryInfo result = new QueryInfo();
        result.query = new Formatter().format(value.query, args).toString();
        result.jsonAware = value.jsonAware;
        result.directContent = value.directContent;
        result.secure = value.secure;
        return result;
    }

    protected Class<?> elementType(Method method) {
        Type rt = method.getGenericReturnType();
        if (!(rt instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Cannot get exact type: " + rt);
        }
        ParameterizedType pt = (ParameterizedType)rt;
        Object[] ats = pt.getActualTypeArguments();
        if (ats == null || ats.length != 1 || !(ats[0] instanceof Class)) {
            throw new IllegalArgumentException("Illegal actual type: " + Arrays.toString(ats));
        }
        return (Class)ats[0];
    }

    protected void packResponseError(Method method, InputStream stream, int status) throws Throwable {
        Object value;
        try {
            value = this.toValue(method, stream);
        }
        catch (Exception ex) {
            throw new RuntimeException("Server error [status: " + status + "] :: ", ex);
        }
        throw new RuntimeException("Server error [status: " + status + "] :: " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object toValue(Method method, InputStream content) throws Throwable {
        boolean closeOnReturn = true;
        content = new ClosedInputStream(content);
        try {
            Class<?> rt = method.getReturnType();
            if (Collection.class.isAssignableFrom(rt)) {
                Class<?> elementClass = this.elementType(method);
                if (JSONAware.class.isAssignableFrom(elementClass)) {
                    Class<?> jsonClass = elementClass;
                    GzipOptionalSerializator serializator = new GzipOptionalSerializator((Serializator)new BufferedSerializator((Serializator)new JSONCollectionSerializator(jsonClass)));
                    if (Set.class.isAssignableFrom(rt)) {
                        Object object = serializator.deserialize(content, HashSet.class);
                        return object;
                    }
                    Object object = serializator.deserialize(content, ArrayList.class);
                    return object;
                }
                String value = ServerProxyHandler.convertStreamToString(content);
                String[] split = value.split(",");
                AbstractCollection result = Set.class.isAssignableFrom(rt) ? new HashSet() : new ArrayList();
                String[] arr$ = split;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) {
                        AbstractCollection abstractCollection = result;
                        return abstractCollection;
                    }
                    String s = arr$[i$];
                    result.add(ConverterUtils.toValue(elementClass, (String)s));
                    ++i$;
                }
            }
            if (JSONAware.class.isAssignableFrom(rt)) {
                Object elementClass = JSONSerializator.OPTIONAL_GZIP_BUFFERED.deserialize(content, rt);
                return elementClass;
            }
            if (InputStream.class.isAssignableFrom(rt)) {
                closeOnReturn = false;
                InputStream elementClass = GzipOptionalSerializator.wrap((InputStream)content);
                return elementClass;
            }
            String value = ServerProxyHandler.convertStreamToString(content);
            Object object = ConverterUtils.toValue(rt, (String)value);
            return object;
        }
        finally {
            try {
                if (closeOnReturn) {
                    content.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return "";
    }

    protected static interface ResultProducer {
        public Result run() throws Throwable;
    }

    protected static class Result {
        private int status;
        private InputStream stream;
        private long executionTime = System.currentTimeMillis();

        private Result() {
        }

        public void end() {
            this.executionTime = System.currentTimeMillis() - this.executionTime;
        }

        public void setStatus(int status) {
            this.status = status;
        }
    }

    protected static class QueryInfo {
        private String query;
        private boolean jsonAware;
        private boolean directContent;
        private boolean secure;

        protected QueryInfo() {
        }
    }
}

