/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.cache.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.cache.CacheEntry;
import javax.cache.CacheListener;
import javax.cache.CacheStatistics;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.jboss.capedwarf.cache.infinispan.InfinispanCacheEntry;
import org.jboss.capedwarf.cache.infinispan.InfinispanCacheListener;
import org.jboss.capedwarf.cache.infinispan.InfinispanCacheStatistics;

class InfinispanCache
implements javax.cache.Cache {
    private final Cache cache;
    private final CacheStatistics stats;

    InfinispanCache(Cache cache) {
        this.cache = cache;
        this.stats = new InfinispanCacheStatistics(cache.getAdvancedCache());
    }

    public void start() {
        this.cache.start();
    }

    public void stop() {
        this.cache.stop();
    }

    public void addListener(CacheListener cacheListener) {
        this.cache.addListener((Object)new InfinispanCacheListener(cacheListener));
    }

    public void removeListener(CacheListener cacheListener) {
        this.cache.removeListener((Object)new InfinispanCacheListener(cacheListener));
    }

    public void evict() {
        this.cache.getAdvancedCache().getEvictionManager().processEviction();
    }

    public Map getAll(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap results = new HashMap();
        for (Object key : collection) {
            results.put(key, this.get(key));
        }
        return results;
    }

    public CacheEntry getCacheEntry(Object key) {
        InternalCacheEntry entry = this.cache.getAdvancedCache().getDataContainer().get(key);
        return entry != null ? new InfinispanCacheEntry(entry) : null;
    }

    public CacheStatistics getCacheStatistics() {
        return this.stats;
    }

    public void load(Object key) {
        this.get(key);
    }

    public void loadAll(Collection c) {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (Object o : c) {
            this.load(o);
        }
    }

    public Object peek(Object key) {
        return this.get(key);
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    public Object get(Object key) {
        return this.cache.get(key);
    }

    public Object put(Object key, Object value) {
        return this.cache.put(key, value);
    }

    public Object remove(Object key) {
        return this.cache.remove(key);
    }

    public void putAll(Map m) {
        this.cache.putAll(m);
    }

    public void clear() {
        this.cache.clear();
    }

    public Set keySet() {
        return this.cache.keySet();
    }

    public Collection values() {
        return this.cache.values();
    }

    public Set entrySet() {
        return this.cache.entrySet();
    }
}

