/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.cache.infinispan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.cache.CacheException;
import javax.cache.CacheFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.capedwarf.cache.infinispan.InfinispanCache;

public class InfinispanCacheFactory
implements CacheFactory {
    private static Logger log = Logger.getLogger(InfinispanCacheFactory.class.getName());
    private static String[] defaultJndiNames = new String[]{"java:jboss/infinispan/container/capedwarf", "java:jboss/infinispan/capedwarf", "java:CacheManager/capedwarf"};
    private EmbeddedCacheManager cacheManager;

    public InfinispanCacheFactory() throws IOException {
        try {
            this.cacheManager = this.doJNDILookup();
        }
        catch (Throwable t) {
            log.warning("Failed to do JNDI lookup, using standalone configuration: " + t);
            this.cacheManager = this.doStandalone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmbeddedCacheManager doJNDILookup() throws IOException {
        Properties jndiProperties = new Properties();
        URL jndiPropertiesURL = this.getClass().getClassLoader().getResource("jndi.properties");
        if (jndiPropertiesURL != null) {
            InputStream is = jndiPropertiesURL.openStream();
            try {
                jndiProperties.load(is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
        String jndiNamespace = jndiProperties.getProperty("infinispan.jndi.name");
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            EmbeddedCacheManager manager = jndiNamespace != null ? (EmbeddedCacheManager)ctx.lookup(jndiNamespace) : this.checkDefaultNames(ctx);
            log.info("Using JNDI found CacheManager: " + manager);
            EmbeddedCacheManager ignored = manager;
            return ignored;
        }
        catch (NamingException ne) {
            String msg = "Unable to retrieve CacheManager from JNDI [" + jndiNamespace + "]";
            log.info(msg + ": " + ne);
            throw new IOException(msg);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    log.info("Unable to release initial context: " + ne);
                }
            }
        }
    }

    protected EmbeddedCacheManager checkDefaultNames(Context ctx) throws IOException {
        for (String jndiName : defaultJndiNames) {
            try {
                return (EmbeddedCacheManager)ctx.lookup(jndiName);
            }
            catch (NamingException ne) {
                String msg = "Unable to retrieve CacheManager from JNDI [" + jndiName + "]";
                log.fine(msg + ": " + ne);
            }
        }
        throw new IOException("Cannot find default JNDI cache manager: " + Arrays.toString(defaultJndiNames));
    }

    protected EmbeddedCacheManager doStandalone() throws IOException {
        String configurationFile = System.getProperty("org.jboss.capedwarf.cache.configurationFile", "infinispan-config.xml");
        return new DefaultCacheManager(configurationFile, true);
    }

    public javax.cache.Cache createCache(Map map) throws CacheException {
        String cacheName = (String)map.get("cache-name");
        Cache cache = this.cacheManager.getCache(cacheName);
        return new InfinispanCache(cache);
    }
}

