/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.cache.infinispan.tx;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.jboss.capedwarf.cache.infinispan.tx.UserTransactionAdapter;

class UTTransaction
extends UserTransactionAdapter
implements Transaction {
    static Transaction INSTANCE = new UTTransaction();
    private static final Logger log = Logger.getLogger(UTTransaction.class.getName());
    private static boolean trace = log.isLoggable(Level.FINEST);
    private static ThreadLocal<Set<Synchronization>> tlSyncs = new ThreadLocal();

    UTTransaction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        block10: {
            try {
                if (this.notifyBeforeCompletion()) {
                    try {
                        this.getUserTransaction().commit();
                        break block10;
                    }
                    finally {
                        this.notifyAfterCompletion(this.getStatus());
                    }
                }
                try {
                    this.getUserTransaction().rollback();
                }
                finally {
                    this.notifyAfterCompletion(4);
                }
            }
            finally {
                UTTransaction.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        try {
            this.getUserTransaction().rollback();
            this.notifyAfterCompletion(4);
        }
        finally {
            UTTransaction.cleanup();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getUserTransaction().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.getUserTransaction().getStatus();
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        return false;
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        return false;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        Set<Synchronization> syncs;
        if (sync == null) {
            throw new IllegalArgumentException("null synchronization " + this);
        }
        int status = this.getStatus();
        switch (status) {
            case 0: 
            case 7: {
                break;
            }
            case 2: {
                throw new IllegalStateException("already prepared. " + this);
            }
            case 8: {
                throw new IllegalStateException("already started committing. " + this);
            }
            case 3: {
                throw new IllegalStateException("already committed. " + this);
            }
            case 1: {
                throw new RollbackException("already marked for rollback " + this);
            }
            case 9: {
                throw new RollbackException("already started rolling back. " + this);
            }
            case 4: {
                throw new RollbackException("already rolled back. " + this);
            }
            case 6: {
                throw new IllegalStateException("no transaction. " + this);
            }
            case 5: {
                throw new IllegalStateException("unknown state " + this);
            }
            default: {
                throw new IllegalStateException("illegal status: " + status + " tx=" + this);
            }
        }
        if (trace) {
            log.finest("registering synchronization handler " + sync);
        }
        if ((syncs = tlSyncs.get()) == null) {
            syncs = new HashSet<Synchronization>(8);
            tlSyncs.set(syncs);
        }
        syncs.add(sync);
    }

    protected boolean notifyBeforeCompletion() throws SystemException {
        Set<Synchronization> syncs = tlSyncs.get();
        if (syncs == null) {
            return true;
        }
        boolean retval = true;
        for (Synchronization s : syncs) {
            if (trace) {
                log.finest("processing beforeCompletion for " + s);
            }
            try {
                s.beforeCompletion();
            }
            catch (Throwable t) {
                retval = false;
                log.log(Level.SEVERE, "beforeCompletion() failed for " + s, t);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAfterCompletion(int status) {
        Set<Synchronization> syncs = tlSyncs.get();
        if (syncs == null) {
            return;
        }
        try {
            for (Synchronization s : syncs) {
                if (trace) {
                    log.finest("processing afterCompletion for " + s);
                }
                try {
                    s.afterCompletion(status);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "afterCompletion() failed for " + s, t);
                }
            }
            syncs.clear();
        }
        finally {
            tlSyncs.remove();
        }
    }
}

