/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.cache.infinispan.tx;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

class UserTransactionAdapter {
    private static ThreadLocal<UserTransaction> uts = new ThreadLocal();
    public static boolean ignoreThreadLocal = Boolean.getBoolean("org.jboss.capedwarf.cache.infinispan.tx.ignoreThreadLocal");

    UserTransactionAdapter() {
    }

    protected UserTransaction getUserTransaction() throws SystemException {
        if (!ignoreThreadLocal) {
            UserTransaction ut = uts.get();
            if (ut == null) {
                ut = this.getUserTransactionInternal();
                uts.set(ut);
            }
            return ut;
        }
        return this.getUserTransactionInternal();
    }

    public static void setup(UserTransaction ut) {
        if (!ignoreThreadLocal) {
            uts.set(ut);
        }
    }

    public static void cleanup() {
        if (!ignoreThreadLocal) {
            uts.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserTransaction getUserTransactionInternal() throws SystemException {
        UserTransaction userTransaction;
        InitialContext context = new InitialContext();
        try {
            Object lookup = context.lookup("java:comp/UserTransaction");
            userTransaction = (UserTransaction)UserTransaction.class.cast(lookup);
        }
        catch (Throwable throwable) {
            try {
                context.close();
                throw throwable;
            }
            catch (NamingException e) {
                throw new SystemException(e.getMessage());
            }
        }
        context.close();
        return userTransaction;
    }
}

