/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.jpa;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jboss.capedwarf.jpa.Entity;
import org.jboss.capedwarf.jpa.EntityManagerProvider;
import org.jboss.capedwarf.jpa.ManyToOne;
import org.jboss.capedwarf.jpa.OneToMany;
import org.jboss.capedwarf.jpa.ProxyingHelper;
import org.jboss.capedwarf.jpa.ProxyingUtils;

class Relationships {
    private static Map<Class<?>, Map<Class<?>, Method>> getIdMapping = new ConcurrentHashMap();
    private static Map<Class<?>, Map<Class<?>, Method>> setIdMapping = new ConcurrentHashMap();
    private static Map<String, String> otmQueries = new ConcurrentHashMap<String, String>();

    Relationships() {
    }

    static Object handleManyToOne(Object entity, Method method, Object[] args, ManyToOne otm, EntityManagerProvider provider) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return Relationships.getMTO(method, otm, entity, provider);
        }
        if (args == null || args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException("Illegals args: " + Arrays.toString(args));
        }
        Relationships.setMTO(method, otm, entity, args[0]);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection handleOneToMany(Object entity, Method method, OneToMany otm, ProxyingHelper helper) throws Throwable {
        if (!(entity instanceof Entity)) {
            throw new IllegalArgumentException("Entity is not an entity: " + entity);
        }
        Class<?> ownerClass = entity.getClass();
        String key = ownerClass.getName() + "::" + method.getName();
        String queryString = otmQueries.get(key);
        if (queryString == null) {
            String joinName;
            Class entityClass = otm.element();
            if (entityClass == Void.class) {
                Type rt = method.getGenericReturnType();
                if (!(rt instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Cannot get exact type: " + rt);
                }
                ParameterizedType pt = (ParameterizedType)rt;
                Object[] ats = pt.getActualTypeArguments();
                if (ats == null || ats.length != 1 || !(ats[0] instanceof Class)) {
                    throw new IllegalArgumentException("Illegal actual type: " + Arrays.toString(ats));
                }
                entityClass = (Class)ats[0];
            }
            if ((joinName = otm.join()) == null || joinName.length() == 0) {
                String ownerName = ownerClass.getSimpleName().toLowerCase();
                joinName = ownerName + "Id";
            }
            StringBuilder builder = new StringBuilder("select e from ");
            builder.append(entityClass.getSimpleName());
            builder.append(" e where e.").append(joinName).append(" = ?1 ");
            builder.append(otm.orderBy());
            queryString = builder.toString().trim();
            otmQueries.put(key, queryString);
        }
        Long id = ((Entity)entity).getId();
        EntityManagerProvider provider = helper.getProvider();
        EntityManager em = provider.getEntityManager();
        try {
            Query query = em.createQuery(queryString);
            query.setParameter(1, (Object)id);
            List result = query.getResultList();
            Collection collection = otm.type().newInstance();
            if (ProxyingUtils.isDisabled()) {
                collection.addAll(result);
            } else {
                for (Object obj : result) {
                    collection.add(helper.wrap(obj));
                }
            }
            Collection collection2 = collection;
            return collection2;
        }
        finally {
            provider.close(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getMTO(Method method, ManyToOne mto, Object entity, EntityManagerProvider provider) throws Throwable {
        Object rel = method.invoke(entity, new Object[0]);
        if (rel == null) {
            Object id;
            Method idMethod;
            Class<?> ec = entity.getClass();
            String methodName = method.getName();
            Class<?> entityClass = method.getReturnType();
            Map<Class<?>, Method> map = getIdMapping.get(ec);
            if (map == null) {
                map = new ConcurrentHashMap();
                getIdMapping.put(ec, map);
            }
            if ((idMethod = map.get(entityClass)) == null) {
                String idName = mto.id();
                if (idName == null || idName.length() == 0) {
                    idName = methodName + "Id";
                }
                idMethod = ec.getMethod(idName, new Class[0]);
                map.put(entityClass, idMethod);
            }
            if ((id = idMethod.invoke(entity, new Object[0])) == null) {
                return null;
            }
            EntityManager em = provider.getEntityManager();
            try {
                rel = em.find(entityClass, id);
            }
            finally {
                provider.close(em);
            }
            Method setter = ec.getMethod("s" + methodName.substring(1), entityClass);
            setter.invoke(entity, rel);
        }
        return rel;
    }

    private static void setMTO(Method method, ManyToOne mto, Object entity, Object value) throws Throwable {
        Method idMethod;
        if (!(value instanceof Entity)) {
            throw new IllegalArgumentException("Value is not an entity: " + value);
        }
        Class<?> ec = entity.getClass();
        String methodName = method.getName();
        Class<?> entityClass = method.getParameterTypes()[0];
        Map<Class<?>, Method> map = setIdMapping.get(ec);
        if (map == null) {
            map = new ConcurrentHashMap();
            setIdMapping.put(ec, map);
        }
        if ((idMethod = map.get(entityClass)) == null) {
            String idName = mto.id();
            if (idName == null || idName.length() == 0) {
                idName = methodName + "Id";
            }
            idMethod = ec.getMethod(idName, Long.class);
            map.put(entityClass, idMethod);
        }
        Long id = ((Entity)value).getId();
        idMethod.invoke(entity, id);
    }
}

