/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.jboss.capedwarf.jpa.ProxyingHelper;
import org.jboss.capedwarf.jpa.ProxyingQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyingEntityManager
extends ProxyingHelper
implements EntityManager {
    private EntityManager delegate;

    protected ProxyingEntityManager(EntityManager delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    public void persist(Object o) {
        Object entity = this.getEntity(o);
        this.delegate.persist(entity);
    }

    public <T> T merge(T t) {
        T entity = this.getEntity(t);
        Object merged = this.delegate.merge(entity);
        return (T)this.wrap(merged);
    }

    public void remove(Object o) {
        Object entity = this.getEntity(o);
        this.delegate.remove(entity);
    }

    public <T> T find(Class<T> tClass, Object o) {
        Object result = this.delegate.find(this.getRealClass(tClass), o);
        return (T)this.safeWrap(result);
    }

    public <T> T getReference(Class<T> tClass, Object o) {
        Object result = this.delegate.getReference(this.getRealClass(tClass), o);
        return (T)this.safeWrap(result);
    }

    public void flush() {
        this.delegate.flush();
    }

    public void setFlushMode(FlushModeType flushModeType) {
        this.delegate.setFlushMode(flushModeType);
    }

    public FlushModeType getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public void lock(Object o, LockModeType lockModeType) {
        Object entity = this.getEntity(o);
        this.delegate.lock(entity, lockModeType);
    }

    public void refresh(Object o) {
        Object entity = this.getEntity(o);
        this.delegate.refresh(entity);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean contains(Object o) {
        Object entity = this.getEntity(o);
        return this.delegate.contains(entity);
    }

    public Query createQuery(String s) {
        Query query = this.delegate.createQuery(s);
        return new ProxyingQuery(this.getProvider(), query);
    }

    public Query createNamedQuery(String s) {
        Query query = this.delegate.createNamedQuery(s);
        return new ProxyingQuery(this.getProvider(), query);
    }

    public Query createNativeQuery(String s) {
        Query query = this.delegate.createNativeQuery(s);
        return new ProxyingQuery(this.getProvider(), query);
    }

    public Query createNativeQuery(String s, Class aClass) {
        Query query = this.delegate.createNativeQuery(s, aClass);
        return new ProxyingQuery(this.getProvider(), query);
    }

    public Query createNativeQuery(String s, String s1) {
        Query query = this.delegate.createNativeQuery(s, s1);
        return new ProxyingQuery(this.getProvider(), query);
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public void joinTransaction() {
        this.delegate.joinTransaction();
    }

    public Object getDelegate() {
        return this.delegate.getDelegate();
    }
}

