/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.jpa;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.capedwarf.jpa.Entity;
import org.jboss.capedwarf.jpa.EntityManagerProvider;
import org.jboss.capedwarf.jpa.ProxyingEntityManager;
import org.jboss.capedwarf.jpa.ProxyingFactory;
import org.jboss.capedwarf.jpa.ProxyingHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyingEntityManagerFactory
implements EntityManagerFactory,
ProxyingFactory {
    private EntityManagerFactory delegate;
    private EntityManagerProvider provider;
    private ProxyingFactory factory;

    public ProxyingEntityManagerFactory(EntityManagerFactory delegate) {
        this(delegate, new NewEntityManagerProvider(delegate));
    }

    public ProxyingEntityManagerFactory(EntityManagerFactory delegate, EntityManagerProvider provider) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Null provider");
        }
        this.delegate = delegate;
        this.provider = provider;
        this.factory = new ProxyingHelper(){

            protected EntityManagerProvider getProvider() {
                return ProxyingEntityManagerFactory.this.provider;
            }
        };
    }

    protected EntityManagerProvider getProviderInternal() {
        return this.provider;
    }

    protected EntityManager proxy(EntityManager delegate) {
        return new ProxyingEntityManager(delegate){

            protected EntityManagerProvider getProvider() {
                return ProxyingEntityManagerFactory.this.getProviderInternal();
            }
        };
    }

    @Override
    public <T extends Entity> T createProxy(Class<T> entityClass) throws Exception {
        return this.factory.createProxy(entityClass);
    }

    @Override
    public boolean isProxy(Entity entity) {
        return this.factory.isProxy(entity);
    }

    public EntityManager createEntityManager() {
        EntityManager em = this.delegate.createEntityManager();
        return this.proxy(em);
    }

    public EntityManager createEntityManager(Map map) {
        EntityManager em = this.delegate.createEntityManager(map);
        return this.proxy(em);
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    private static class NewEntityManagerProvider
    implements EntityManagerProvider {
        private EntityManagerFactory emf;

        private NewEntityManagerProvider(EntityManagerFactory emf) {
            if (emf == null) {
                throw new IllegalArgumentException("Null emf");
            }
            this.emf = emf;
        }

        public EntityManager getEntityManager() {
            return this.emf.createEntityManager();
        }

        public void close(EntityManager em) {
            em.close();
        }
    }
}

