/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.jpa;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.jboss.capedwarf.jpa.DisableProxy;
import org.jboss.capedwarf.jpa.Entity;
import org.jboss.capedwarf.jpa.EntityManagerProvider;
import org.jboss.capedwarf.jpa.ManyToOne;
import org.jboss.capedwarf.jpa.OneToMany;
import org.jboss.capedwarf.jpa.ProxyEntity;
import org.jboss.capedwarf.jpa.ProxyingFactory;
import org.jboss.capedwarf.jpa.ProxyingUtils;
import org.jboss.capedwarf.jpa.Relationships;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ProxyingHelper
implements ProxyingFactory {
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            return !"finalize".equals(m.getName()) || m.getParameterTypes().length != 0;
        }
    };

    ProxyingHelper() {
    }

    @Override
    public <T extends Entity> T createProxy(Class<T> entityClass) throws Exception {
        if (entityClass == null) {
            throw new IllegalArgumentException("Null entity class");
        }
        Entity instance = (Entity)entityClass.newInstance();
        return (T)this.wrap(instance);
    }

    @Override
    public boolean isProxy(Entity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity");
        }
        Class<?> ec = entity.getClass();
        return ProxyFactory.isProxyClass(ec);
    }

    protected abstract EntityManagerProvider getProvider();

    protected <T> T getEntity(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Null entity");
        }
        Class<?> ec = obj.getClass();
        if (!ProxyFactory.isProxyClass(ec)) {
            return obj;
        }
        if (!(obj instanceof ProxyEntity)) {
            throw new IllegalArgumentException("Object is not a ProxyEntity: " + obj);
        }
        ProxyEntity pe = (ProxyEntity)obj;
        return pe.getRealEntity();
    }

    protected <T> T safeWrap(T entity) {
        return entity != null ? (T)this.wrap(entity) : null;
    }

    protected <X> Class<X> getRealClass(Class<X> clazz) {
        if (ProxyFactory.isProxyClass(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    protected <T> T wrap(final T entity) {
        ProxyObject proxy;
        if (entity == null) {
            throw new IllegalArgumentException("Null entity");
        }
        Class<?> ec = entity.getClass();
        if (ProxyingUtils.isDisabled() || ProxyFactory.isProxyClass(ec) || ec.isAnnotationPresent(DisableProxy.class) || !ec.isAnnotationPresent(javax.persistence.Entity.class)) {
            return entity;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setFilter(FINALIZE_FILTER);
        factory.setSuperclass(ec);
        factory.setInterfaces(new Class[]{ProxyEntity.class});
        Class<?> proxyClass = ProxyingHelper.getProxyClass(factory);
        try {
            proxy = (ProxyObject)proxyClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        proxy.setHandler(new MethodHandler(){

            public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
                if ((args == null || args.length == 0) && "getRealEntity".equals(method.getName())) {
                    return entity;
                }
                if ((args == null || args.length == 0) && "hashCode".equals(method.getName())) {
                    return entity.hashCode();
                }
                if (args != null && args.length == 1 && "equals".equals(method.getName())) {
                    Object other = args[0];
                    return other != null && entity.equals(ProxyingHelper.this.getEntity(other));
                }
                ManyToOne mto = method.getAnnotation(ManyToOne.class);
                if (mto != null) {
                    return Relationships.handleManyToOne(entity, method, args, mto, ProxyingHelper.this.getProvider());
                }
                OneToMany otm = method.getAnnotation(OneToMany.class);
                if (otm != null) {
                    return Relationships.handleOneToMany(entity, method, otm, ProxyingHelper.this);
                }
                return method.invoke(entity, args);
            }
        });
        return (T)proxy;
    }

    protected static Class<?> getProxyClass(ProxyFactory factory) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return factory.createClass();
        }
        return (Class)AccessController.doPrivileged(new ClassCreator(factory));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassCreator
    implements PrivilegedAction<Class<?>> {
        private ProxyFactory factory;

        public ClassCreator(ProxyFactory factory) {
            this.factory = factory;
        }

        @Override
        public Class<?> run() {
            return this.factory.createClass();
        }
    }
}

