/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.cache;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.cache.CacheException;
import org.jboss.capedwarf.jpa.Entity;
import org.jboss.capedwarf.server.api.cache.CacheConfig;
import org.jboss.capedwarf.server.api.cache.CacheEntryLookup;
import org.jboss.capedwarf.server.api.cache.EntityListCachedResult;
import org.jboss.capedwarf.server.api.cache.KeyStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityListKeyStrategy<T extends EntityListCachedResult, E extends Entity>
implements KeyStrategy<T, List<E>> {
    private CacheEntryLookup lookup;

    protected EntityListKeyStrategy(CacheConfig config) throws CacheException {
        if (config == null) {
            throw new IllegalArgumentException("Null cache config");
        }
        this.lookup = config.getLookup(null);
    }

    protected abstract Class<E> getEntityClass();

    @Override
    public List<E> unwrap(T cached, Object target, Method method, Object[] args) {
        List<Long> ids = ((EntityListCachedResult)cached).getIds();
        return this.getEntities(ids);
    }

    protected List<E> getEntities(List<Long> ids) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Long id : ids) {
            Entity entity = (Entity)this.lookup.getCachedEntry(this.getEntityClass(), id);
            if (entity == null) {
                return null;
            }
            entities.add(entity);
        }
        return entities;
    }
}

