/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.cache.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheFactory;
import javax.cache.CacheManager;
import javax.inject.Inject;
import org.jboss.capedwarf.server.api.cache.CacheConfig;
import org.jboss.capedwarf.server.api.cache.CacheEntryLookup;
import org.jboss.capedwarf.server.api.cache.CacheExceptionHandler;
import org.jboss.capedwarf.server.api.cache.impl.AbstractCacheEntryLookup;
import org.jboss.capedwarf.server.api.cache.impl.NoopCacheExceptionHandler;
import org.jboss.seam.solder.resourceLoader.Resource;

public abstract class AbstractCacheConfig
implements CacheConfig {
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private Properties props;
    private CacheManager manager;
    private Map<String, CacheEntryLookup> lookups = new ConcurrentHashMap<String, CacheEntryLookup>();

    protected abstract Map createConfig(String var1);

    public Cache findCache(String name) {
        return this.manager.getCache(name);
    }

    public Cache configureCache(String name) throws CacheException {
        Cache cache = this.manager.getCache(name);
        if (cache != null) {
            return cache;
        }
        Map config = this.createConfig(name);
        HashMap<String, String> wrappedConfig = new HashMap<String, String>(config);
        wrappedConfig.put("cache-name", name);
        CacheFactory factory = this.manager.getCacheFactory();
        cache = factory.createCache(wrappedConfig);
        this.manager.registerCache(name, cache);
        return cache;
    }

    public boolean evictCache(String name) {
        Cache cache = this.manager.getCache(name);
        if (cache != null) {
            cache.evict();
            return true;
        }
        return false;
    }

    public boolean clearCache(String name) {
        Cache cache = this.manager.getCache(name);
        if (cache != null) {
            cache.clear();
            return true;
        }
        return false;
    }

    public void disposeCache(Cache cache) {
    }

    public CacheEntryLookup getLookup(String cacheName) throws CacheException {
        if (cacheName == null && (cacheName = this.getProps().getProperty("jpa.cache.name")) == null) {
            throw new CacheException("Missing JPA entity cache name.");
        }
        CacheEntryLookup cel = this.lookups.get(cacheName);
        if (cel != null) {
            return cel;
        }
        AbstractCacheEntryLookup acel = this.createLookup();
        acel.setCache(this.configureCache(cacheName));
        this.lookups.put(cacheName, acel);
        return acel;
    }

    protected abstract AbstractCacheEntryLookup createLookup();

    public CacheExceptionHandler getExceptionHandler() {
        String ehClassName = this.getProps().getProperty("cache.exception.handler");
        if (ehClassName != null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(ehClassName);
                return (CacheExceptionHandler)clazz.newInstance();
            }
            catch (Exception e) {
                this.log.warning("Cannot instantiate cache exception handler: " + e);
            }
        }
        return NoopCacheExceptionHandler.INSTANCE;
    }

    @Inject
    public void setManager(CacheManager manager) {
        this.manager = manager;
    }

    protected Properties getProps() {
        return this.props;
    }

    @Inject
    public void setProps(@Resource(value="cache.properties") Properties props) {
        this.props = props;
    }
}

