/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.domain;

import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.persistence.Embeddable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Embeddable
public class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = ".";
    private static final String PATTERN = "[a-zA-Z0-9_-]*";
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("[a-zA-Z0-9_-]*");
    public static final Version DEFAULT_VERSION = new Version(0, 0, 0);
    private int major;
    private int minor;
    private int micro;
    private String qualifier;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public Version() {
    }

    public static Version valueOf(String string) {
        return Version.parseVersion(string);
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        if (qualifier == null) {
            qualifier = "";
        }
        this.qualifier = qualifier;
        this.validate();
    }

    private Version(String version) {
        int major;
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            major = Integer.parseInt(st.nextToken().trim());
            if (st.hasMoreTokens()) {
                st.nextToken();
                minor = Integer.parseInt(st.nextToken().trim());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    micro = Integer.parseInt(st.nextToken().trim());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        qualifier = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("Invalid version format, too many seperators: " + version);
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid version format: " + version);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version format: " + version, e);
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.validate();
    }

    protected void validate() {
        if (Version.jdoGetmajor(this) < 0) {
            throw new IllegalArgumentException("negative major: " + Version.jdoGetmajor(this));
        }
        if (Version.jdoGetminor(this) < 0) {
            throw new IllegalArgumentException("negative minor: " + Version.jdoGetminor(this));
        }
        if (Version.jdoGetmicro(this) < 0) {
            throw new IllegalArgumentException("negative micro: " + Version.jdoGetmicro(this));
        }
        if (!QUALIFIER_PATTERN.matcher(Version.jdoGetqualifier(this)).matches()) {
            throw new IllegalArgumentException("Invalid qualifier, it must be [a-zA-Z0-9_-]*: " + Version.jdoGetqualifier(this));
        }
    }

    public static Version parseVersion(String version) {
        if (version == null) {
            return DEFAULT_VERSION;
        }
        if ((version = version.trim()).length() == 0) {
            return DEFAULT_VERSION;
        }
        return new Version(version);
    }

    public int getMajor() {
        return Version.jdoGetmajor(this);
    }

    public void setMajor(int major) {
        Version.jdoSetmajor(this, major);
    }

    public int getMinor() {
        return Version.jdoGetminor(this);
    }

    public void setMinor(int minor) {
        Version.jdoSetminor(this, minor);
    }

    public int getMicro() {
        return Version.jdoGetmicro(this);
    }

    public void setMicro(int micro) {
        Version.jdoSetmicro(this, micro);
    }

    public String getQualifier() {
        return Version.jdoGetqualifier(this);
    }

    public void setQualifier(String qualifier) {
        Version.jdoSetqualifier(this, qualifier);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Version.jdoGetmajor(this)).append(SEPARATOR).append(Version.jdoGetminor(this)).append(SEPARATOR).append(Version.jdoGetmicro(this));
        if (Version.jdoGetqualifier(this).length() > 0) {
            builder.append(SEPARATOR).append(Version.jdoGetqualifier(this));
        }
        return builder.toString();
    }

    public int hashCode() {
        return (Version.jdoGetmajor(this) << 24) + (Version.jdoGetminor(this) << 16) + (Version.jdoGetmicro(this) << 8) + Version.jdoGetqualifier(this).hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        int result = Version.jdoGetmajor(this) - Version.jdoGetmajor(version);
        if (result != 0) {
            return result;
        }
        result = Version.jdoGetminor(this) - Version.jdoGetminor(version);
        if (result != 0) {
            return result;
        }
        result = Version.jdoGetmicro(this) - Version.jdoGetmicro(version);
        if (result != 0) {
            return result;
        }
        return Version.jdoGetqualifier(this).compareTo(Version.jdoGetqualifier(version));
    }

    static {
        jdoFieldNames = Version.__jdoFieldNamesInit();
        jdoFieldTypes = Version.__jdoFieldTypesInit();
        jdoFieldFlags = Version.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Version.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Version.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Version.___jdo$loadClass("org.jboss.capedwarf.server.api.domain.Version"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Version());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return null;
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        return null;
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Version result = new Version();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Version result = new Version();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.major = this.jdoStateManager.replacingIntField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.micro = this.jdoStateManager.replacingIntField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.minor = this.jdoStateManager.replacingIntField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.qualifier = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, index, this.major);
                break;
            }
            case 1: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, index, this.micro);
                break;
            }
            case 2: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, index, this.minor);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.qualifier);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Version obj, int index) {
        switch (index) {
            case 0: {
                this.major = obj.major;
                break;
            }
            case 1: {
                this.micro = obj.micro;
                break;
            }
            case 2: {
                this.minor = obj.minor;
                break;
            }
            case 3: {
                this.qualifier = obj.qualifier;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Version)) {
            throw new IllegalArgumentException("object is not an object of type org.jboss.capedwarf.server.api.domain.Version");
        }
        Version other = (Version)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"major", "micro", "minor", "qualifier"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Version.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 4;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Version o = (Version)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private final void writeObject(ObjectOutputStream out) {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }

    private static int jdoGetmajor(Version objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 0, objPC.major);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"major\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.major;
    }

    private static void jdoSetmajor(Version objPC, int val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 0, objPC.major, val);
        } else {
            objPC.major = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static int jdoGetmicro(Version objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 1, objPC.micro);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"micro\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.micro;
    }

    private static void jdoSetmicro(Version objPC, int val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 1, objPC.micro, val);
        } else {
            objPC.micro = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static int jdoGetminor(Version objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 2, objPC.minor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"minor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.minor;
    }

    private static void jdoSetminor(Version objPC, int val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 2, objPC.minor, val);
        } else {
            objPC.minor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetqualifier(Version objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.qualifier);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"qualifier\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.qualifier;
    }

    private static void jdoSetqualifier(Version objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.qualifier, val);
        } else {
            objPC.qualifier = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }
}

