/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.io;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.server.api.io.Blob;
import org.jboss.capedwarf.server.api.io.BlobService;

public abstract class AbstractBlobService
implements BlobService {
    public Blob toBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.toBlobInternal(bytes);
    }

    protected abstract Blob toBlobInternal(byte[] var1);

    public byte[] loadBytes(String key) {
        return this.loadBytesInternal(key, 0L, Long.MAX_VALUE);
    }

    public byte[] loadBytes(String key, long startIndex, long endIndex) {
        if (key == null || startIndex > endIndex) {
            return null;
        }
        if (startIndex == endIndex) {
            return new byte[0];
        }
        return this.loadBytesInternal(key, startIndex, endIndex);
    }

    protected abstract byte[] loadBytesInternal(String var1, long var2, long var4);

    public void serveBytes(String key, HttpServletResponse response) throws IOException {
        this.serveBytes(key, 0L, response);
    }

    public void serveBytes(String key, long start, HttpServletResponse response) throws IOException {
        this.serveBytes(key, start, -1L, response);
    }

    public void serveBytes(String key, long start, long end, HttpServletResponse response) throws IOException {
        if (key == null) {
            return;
        }
        this.serveBytesInternal(key, start, end, response);
    }

    protected abstract void serveBytesInternal(String var1, long var2, long var4, HttpServletResponse var6) throws IOException;

    public String storeBytes(String mimeType, byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return this.storeBytesInternal(mimeType, bytes);
    }

    protected abstract String storeBytesInternal(String var1, byte[] var2) throws IOException;
}

