/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.mvc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.common.serialization.ConverterUtils;
import org.jboss.capedwarf.server.api.servlet.AbstractRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAction
extends AbstractRequestHandler {
    protected Logger log = Logger.getLogger(this.getClass().getName());

    @Override
    protected void doInitialize(ServletContext context) {
    }

    protected static String getParameter(HttpServletRequest req, String name) {
        return AbstractAction.getParameter(req, name, true);
    }

    protected static String getParameter(HttpServletRequest req, String name, boolean required) {
        String value = req.getParameter(name);
        if (value == null && required) {
            throw new IllegalArgumentException("Missing parameter " + name);
        }
        return value;
    }

    protected static long parseLong(HttpServletRequest req, String name) {
        String value = AbstractAction.getParameter(req, name);
        return Long.parseLong(value);
    }

    protected static int parseInt(HttpServletRequest req, String name) {
        String value = AbstractAction.getParameter(req, name);
        return Integer.parseInt(value);
    }

    protected static <T extends Enum> T parseEnum(HttpServletRequest req, String name, T defaultValue, T[] values) {
        String type = AbstractAction.getParameter(req, name);
        int ordinal = type != null ? Integer.parseInt(type) : -1;
        return ordinal < 0 || ordinal >= values.length ? defaultValue : values[ordinal];
    }

    protected <T> List<T> parseList(HttpServletRequest req, String name, Class<T> clazz) throws IOException {
        try {
            ArrayList<T> result = new ArrayList<T>();
            String value = AbstractAction.getParameter(req, name, false);
            if (value != null) {
                String[] split;
                for (String s : split = value.split(",")) {
                    Object element = ConverterUtils.toValue(clazz, (String)s);
                    result.add(clazz.cast(element));
                }
            }
            return result;
        }
        catch (Throwable t) {
            IOException ioe = new IOException();
            ioe.initCause(t);
            throw ioe;
        }
    }

    protected void prepareResponse(HttpServletResponse resp) {
        resp.setCharacterEncoding("UTF-8");
    }

    protected void writeResult(HttpServletResponse resp, Object result) throws IOException {
        if (result instanceof Iterable) {
            this.writeResults(resp, (Iterable)result);
        } else {
            this.prepareResponse(resp);
            PrintWriter writer = resp.getWriter();
            ((Writer)writer).write(String.valueOf(result));
            ((Writer)writer).flush();
        }
    }

    protected void writeResults(HttpServletResponse resp, Iterable results) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (Object arg : results) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(arg);
        }
        this.writeResult(resp, builder);
    }
}

