/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.mvc;

import java.io.IOException;
import java.util.HashSet;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.server.api.mvc.HandlerMapping;
import org.jboss.capedwarf.server.api.servlet.AbstractRequestHandler;
import org.jboss.capedwarf.server.api.servlet.RequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRequestHandler
extends AbstractRequestHandler {
    private ServletContext context;
    private Iterable<HandlerMapping> mappings;

    @Override
    protected void doInitialize(ServletContext context) {
        this.context = context;
        for (HandlerMapping hm : this.mappings) {
            hm.initialize(context);
        }
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestHandler handler = this.findHandler(req);
        handler.initialize(this.context);
        handler.handle(req, resp);
    }

    protected RequestHandler findHandler(HttpServletRequest req) throws ServletException {
        for (HandlerMapping hm : this.mappings) {
            RequestHandler handler = hm.findHandler(req);
            if (handler == null) continue;
            return handler;
        }
        throw new ServletException("No such mapping: " + req);
    }

    @Inject
    public void setMappings(Instance<HandlerMapping> mappings) {
        HashSet<HandlerMapping> hms = new HashSet<HandlerMapping>();
        for (HandlerMapping hm : mappings) {
            hms.add(hm);
        }
        this.mappings = hms;
    }
}

