/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.ui;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jboss.capedwarf.jpa.Entity;
import org.jboss.capedwarf.jpa.ProxyingEnum;
import org.jboss.capedwarf.server.api.persistence.EMInjector;
import org.jboss.capedwarf.server.api.persistence.Proxying;
import org.jboss.capedwarf.server.api.security.Security;
import org.jboss.capedwarf.server.api.tx.Transactional;
import org.jboss.capedwarf.server.api.ui.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="sql")
@ConversationScoped
public class SqlCommand
extends Command
implements Serializable {
    private static final long serialVersionUID = 1L;
    private EMInjector emInjector;
    private List<Entity> results;
    private int count = -1;

    public int getSize() {
        return this.results != null ? this.results.size() : 0;
    }

    public List<Entity> getResults() {
        return this.results;
    }

    public int getCount() {
        return this.count;
    }

    @Security(value={"admin", "editor"})
    @Transactional
    @Proxying(value=ProxyingEnum.DISABLE)
    public void executeSelect() {
        String query = this.getParameter("select", "query");
        EntityManager em = this.emInjector.getEM();
        Query q = em.createQuery(query);
        this.results = q.getResultList();
    }

    @Transactional
    @Security
    public void executeDelete() {
        String query = this.getParameter("delete", "query");
        EntityManager em = this.emInjector.getEM();
        Query q = em.createQuery(query);
        this.count = q.executeUpdate();
    }

    @Inject
    public void setEmInjector(EMInjector emInjector) {
        this.emInjector = emInjector;
    }
}

