/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.captcha.impl;

import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.DefaultManageableImageCaptchaService;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import org.jboss.capedwarf.server.api.captcha.impl.AbstractCaptchaService;

@ApplicationScoped
@Alternative
public class JCaptchaService
extends AbstractCaptchaService {
    private static final long serialVersionUID = 1L;
    private volatile ImageCaptchaService imageCaptchaService;

    protected ImageCaptchaService getImageCaptchaService() {
        if (this.imageCaptchaService == null) {
            this.imageCaptchaService = new DefaultManageableImageCaptchaService();
        }
        return this.imageCaptchaService;
    }

    public void serveCaptcha(String id, Locale locale, String format, OutputStream out) throws IOException {
        BufferedImage challenge = this.getImageCaptchaService().getImageChallengeForID(id, locale);
        this.renderCaptcha(challenge, format, out);
    }

    public boolean verifyCaptcha(String id, String captcha) {
        Boolean isResponseCorrect = Boolean.FALSE;
        try {
            isResponseCorrect = this.getImageCaptchaService().validateResponseForID(id, (Object)captcha);
        }
        catch (CaptchaServiceException ignored) {
            // empty catch block
        }
        if (isResponseCorrect == null) {
            throw new IllegalStateException("Invalid CAPTCHA!");
        }
        return isResponseCorrect;
    }

    public void setImageCaptchaService(ImageCaptchaService imageCaptchaService) {
        this.imageCaptchaService = imageCaptchaService;
    }
}

