/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.captcha.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import net.tanesha.recaptcha.ReCaptcha;
import net.tanesha.recaptcha.ReCaptchaFactory;
import net.tanesha.recaptcha.ReCaptchaResponse;
import org.jboss.capedwarf.server.api.captcha.impl.AbstractCaptchaService;

@Alternative
@ApplicationScoped
public class ReCaptchaService
extends AbstractCaptchaService {
    private static final long serialVersionUID = 1L;
    private String publicKey;
    private String privateKey;
    private volatile ReCaptcha captcha;
    private volatile HttpServletRequest request;

    protected synchronized ReCaptcha getCaptcha() {
        if (this.captcha == null) {
            this.captcha = ReCaptchaFactory.newReCaptcha((String)this.publicKey, (String)this.privateKey, (boolean)false);
        }
        return this.captcha;
    }

    public void serveCaptcha(String id, Locale locale, String format, OutputStream out) throws IOException {
        String error = this.request.getParameter("error");
        String captchaScript = this.getCaptcha().createRecaptchaHtml(error, null);
        out.write(captchaScript.getBytes());
    }

    public boolean verifyCaptcha(String id, String value) {
        ReCaptchaResponse response = this.getCaptcha().checkAnswer(this.request.getRemoteAddr(), this.request.getParameter("recaptcha_challenge_field"), this.request.getParameter("recaptcha_response_field"));
        return response.isValid();
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Inject
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

