/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.dao.impl;

import java.util.Collections;
import java.util.List;
import org.jboss.capedwarf.server.api.cache.EntityListCachedResult;
import org.jboss.capedwarf.server.api.domain.TimestampedEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimestampedListCachedResult
extends EntityListCachedResult {
    private static final long serialVersionUID = 1L;
    private long timestamp;
    private long[] timestamps;

    public TimestampedListCachedResult(long timestamp, List<? extends TimestampedEntity> results) {
        super(TimestampedListCachedResult.toIds(results));
        this.timestamp = timestamp;
        if (results != null && !results.isEmpty()) {
            this.timestamps = new long[results.size()];
            int i = 0;
            for (TimestampedEntity timestampedEntity : results) {
                this.timestamps[i++] = timestampedEntity.getTimestamp();
            }
        } else {
            this.timestamps = new long[0];
        }
    }

    List<Long> getSubList(long ts) {
        if (ts < this.timestamp) {
            return null;
        }
        int size = this.timestamps.length;
        if (size == 0) {
            return Collections.emptyList();
        }
        long lastTs = this.timestamps[size - 1];
        if (ts > lastTs) {
            return Collections.emptyList();
        }
        for (int i = 0; i < size; ++i) {
            Long te = this.timestamps[i];
            if (te <= ts) continue;
            return this.getIds().subList(i, size);
        }
        return Collections.emptyList();
    }
}

