/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.dao.impl;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.List;
import javax.cache.CacheException;
import org.jboss.capedwarf.server.api.cache.CacheConfig;
import org.jboss.capedwarf.server.api.cache.EntityListKeyStrategy;
import org.jboss.capedwarf.server.api.dao.impl.TimestampedListCachedResult;
import org.jboss.capedwarf.server.api.domain.TimestampedEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimestampedListKeyStrategy<E extends TimestampedEntity>
extends EntityListKeyStrategy<TimestampedListCachedResult, E> {
    protected TimestampedListKeyStrategy(CacheConfig config) throws CacheException {
        super(config);
    }

    protected int getKeyIndex() {
        return 0;
    }

    protected int getTimestampIndex() {
        return 1;
    }

    @Override
    public Serializable createKey(Object target, Method method, Object[] args) {
        Prefix prefix = method.getAnnotation(Prefix.class);
        return this.createKey(prefix != null ? prefix.value() : null, args[this.getKeyIndex()]);
    }

    protected Serializable createKey(String prefix, Object arg) {
        return prefix != null ? prefix + arg : (Serializable)arg;
    }

    @Override
    public TimestampedListCachedResult wrap(List<E> orginal, Object target, Method method, Object[] args) {
        return new TimestampedListCachedResult((Long)args[this.getTimestampIndex()], orginal);
    }

    @Override
    public List<E> unwrap(TimestampedListCachedResult cached, Object target, Method method, Object[] args) {
        List<Long> ids = cached.getSubList((Long)args[this.getTimestampIndex()]);
        return this.getEntities(ids);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Prefix {
        public String value();
    }
}

