/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.mvc;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.server.api.mvc.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultAbstractAction<R>
extends AbstractAction {
    private boolean suppressException = true;

    protected abstract R doHandle(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            R result = this.doHandle(req, resp);
            this.doWriteResult(resp, result);
        }
        catch (ServletException e) {
            this.handle(resp, e);
        }
        catch (IOException e) {
            this.handle(resp, e);
        }
        catch (RuntimeException e) {
            this.handle(resp, e);
        }
    }

    protected void doWriteResult(HttpServletResponse resp, R result) throws IOException {
        this.writeResult(resp, result);
    }

    protected abstract R errorResult();

    private <T extends Throwable> void handle(HttpServletResponse resp, T t) throws T {
        if (this.suppressException) {
            try {
                this.log.log(Level.WARNING, "Ignoring exception.", t);
                this.doWriteResult(resp, this.errorResult());
            }
            catch (IOException iOException) {}
        } else {
            throw t;
        }
    }

    public void setSuppressException(boolean suppressException) {
        this.suppressException = suppressException;
    }
}

