/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.persistence;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.capedwarf.jpa.EntityManagerProvider;
import org.jboss.capedwarf.jpa.ProxyingFactory;
import org.jboss.capedwarf.jpa.ProxyingWrapper;
import org.jboss.capedwarf.server.api.lifecycle.AfterImpl;
import org.jboss.capedwarf.server.api.lifecycle.BeforeImpl;
import org.jboss.capedwarf.server.api.lifecycle.Notification;
import org.jboss.capedwarf.server.api.persistence.EMFInfo;
import org.jboss.capedwarf.server.api.persistence.EMFNotification;
import org.jboss.capedwarf.server.api.persistence.EMInjector;
import org.jboss.capedwarf.server.api.persistence.LazyEntityManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class EMF {
    private volatile EntityManagerFactory emf;
    private Event<Notification<EntityManagerFactory>> produceEvent;

    @Produces
    @ApplicationScoped
    public EntityManagerFactory produceFactory(EMFInfo info) {
        this.produceEvent.select(new Annotation[]{new BeforeImpl()}).fire((Object)new EMFNotification(null));
        EntityManagerFactory entityManagerFactory = this.getFactory(info);
        this.produceEvent.select(new Annotation[]{new AfterImpl()}).fire((Object)new EMFNotification(entityManagerFactory));
        return entityManagerFactory;
    }

    @Produces
    @ApplicationScoped
    public ProxyingFactory produceProxyingFactory(EMFInfo info) {
        return (ProxyingFactory)this.getFactory(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory getFactory(EMFInfo info) {
        if (this.emf == null) {
            EMF eMF = this;
            synchronized (eMF) {
                if (this.emf == null) {
                    LazyEntityManagerFactory delegate = new LazyEntityManagerFactory(info.getUnitName());
                    CurrentEntityManagerProvider provider = new CurrentEntityManagerProvider(delegate, info.getEmInjector());
                    ProxyingWrapper wrapper = info.getWrapper();
                    this.emf = wrapper.wrap((EntityManagerFactory)delegate, (EntityManagerProvider)provider);
                }
            }
        }
        return this.emf;
    }

    @Inject
    public void setProduceEvent(Event<Notification<EntityManagerFactory>> produceEvent) {
        this.produceEvent = produceEvent;
    }

    private static class CurrentEntityManagerProvider
    implements EntityManagerProvider {
        private EntityManagerFactory emf;
        private EMInjector emInjector;

        private CurrentEntityManagerProvider(EntityManagerFactory emf, EMInjector emInjector) {
            this.emf = emf;
            this.emInjector = emInjector;
        }

        public EntityManager getEntityManager() {
            EntityManager em = this.emInjector.getEM();
            return em != null ? em : this.emf.createEntityManager();
        }

        public void close(EntityManager em) {
            EntityManager tmp = this.emInjector.getEM();
            if (tmp != em) {
                em.close();
            }
        }
    }
}

