/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.persistence;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

class LazyEntityManagerFactory
implements EntityManagerFactory {
    private String puName;
    private volatile EntityManagerFactory delegate;

    LazyEntityManagerFactory(String puName) {
        if (puName == null) {
            throw new IllegalArgumentException("Null PU name");
        }
        this.puName = puName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory getDelegate() {
        if (this.delegate == null) {
            LazyEntityManagerFactory lazyEntityManagerFactory = this;
            synchronized (lazyEntityManagerFactory) {
                if (this.delegate == null) {
                    this.delegate = Persistence.createEntityManagerFactory((String)this.puName);
                }
            }
        }
        return this.delegate;
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.getDelegate().createEntityManager(map);
    }

    public void close() {
        EntityManagerFactory temp = this.delegate;
        if (temp != null) {
            temp.close();
        }
    }

    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }
}

