/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.security;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.capedwarf.server.api.admin.AdminManager;
import org.jboss.capedwarf.server.api.quilifiers.Current;
import org.jboss.capedwarf.server.api.security.Security;
import org.jboss.capedwarf.server.api.users.User;

@Security
@Interceptor
public class SecurityInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient User user;
    private transient AdminManager adminManager;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Method method = invocation.getMethod();
        Security security = method.getAnnotation(Security.class);
        if (security == null) {
            Class<?> clazz = invocation.getTarget().getClass();
            security = clazz.getAnnotation(Security.class);
        }
        if (security != null && security.value().length > 0) {
            if (this.user == null) {
                throw new IllegalArgumentException("Null user, but required roles!");
            }
            String email = this.user.getEmail();
            String[] roles = security.value();
            boolean allowed = false;
            for (String role : roles) {
                if (!this.adminManager.isUserInRole(email, role)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                throw new IllegalArgumentException("Illegal user [" + this.user + "], missing proper role: " + Arrays.asList(roles));
            }
            return invocation.proceed();
        }
        return invocation.proceed();
    }

    @Inject
    public void setUser(@Current User user) {
        this.user = user;
    }

    @Inject
    public void setAdminManager(AdminManager adminManager) {
        this.adminManager = adminManager;
    }
}

