/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.ui;

import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.capedwarf.server.api.admin.AdminManager;
import org.jboss.capedwarf.server.api.quilifiers.Current;
import org.jboss.capedwarf.server.api.users.User;

@Named(value="login")
@RequestScoped
public class Login
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AdminManager adminManager;
    private User user;

    protected boolean isLoggedIn(String role) {
        if (this.user != null) {
            String email = this.user.getEmail();
            return this.adminManager.isUserInRole(email, role);
        }
        return false;
    }

    public boolean isLoggedIn() {
        return this.user != null;
    }

    public boolean isAdmin() {
        return this.isLoggedIn("admin");
    }

    public boolean isEditor() {
        return this.isLoggedIn("editor") || this.isAdmin();
    }

    public User getUser() {
        return this.user;
    }

    @Inject
    public void setAdminManager(AdminManager adminManager) {
        this.adminManager = adminManager;
    }

    @Inject
    public void setUser(@Current User user) {
        this.user = user;
    }
}

