/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.users;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.server.api.quilifiers.Current;
import org.jboss.capedwarf.server.api.users.User;
import org.jboss.capedwarf.server.api.users.UserHandler;

@Named(value="LoginHandler")
public class LoginHandler {
    private User user;
    private UserHandler userHandler;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public void login() throws IOException {
        if (this.user == null) {
            String requestURI = this.request.getRequestURI();
            String loginURL = this.userHandler.loginURL(requestURI);
            this.response.sendRedirect(loginURL);
        }
    }

    public void logout() throws IOException {
        if (this.user != null) {
            String requestURI = this.request.getRequestURI();
            String logoutURL = this.userHandler.logoutURL(requestURI);
            this.response.sendRedirect(logoutURL);
        }
    }

    @Inject
    public void setUser(@Current User user) {
        this.user = user;
    }

    @Inject
    public void setUserHandler(UserHandler userHandler) {
        this.userHandler = userHandler;
    }

    @Inject
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Inject
    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }
}

