/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.jboss.capedwarf.server.api.io.Blob;
import org.jboss.capedwarf.server.api.validation.BlobSize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobSizeValidator
implements ConstraintValidator<BlobSize, Object> {
    private int min;
    private int max;

    public void initialize(BlobSize bs) {
        this.min = bs.min();
        this.max = bs.max();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof Blob)) {
            return false;
        }
        Blob blob = (Blob)value;
        byte[] bytes = blob.getBytes();
        int length = bytes.length;
        return length >= this.min && length <= this.max;
    }
}

