/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.capedwarf.server.api.admin;

import java.util.Set;

/**
 * Admin manager.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public interface AdminManager
{
   /**
    * Get roles.
    *
    * @param identification the identification
    * @return roles
    */
   Set<String> getRoles(String identification);

   /**
    * Is user in role.
    *
    * @param identification the identification
    * @param role the role
    * @return true if user in role, false otherwise
    */
   boolean isUserInRole(String identification, String role);

   /**
    * Get users by role.
    *
    * @param role the role
    * @return users
    */
   Set<String> getUsers(String role);

   /**
    * Get app admin email.
    *
    * @return the app admin email
    */
   String getAppAdminEmail();

   /**
    * Get app dev email.
    *
    * @return the app admin email
    */
   String getAppDevEmail();
}
