/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.admin.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.capedwarf.server.api.admin.AdminManager;
import org.jboss.seam.solder.resourceLoader.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class BasicAdminManager
implements AdminManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Set<String>> users = Collections.emptyMap();
    private Map<String, Set<String>> roles = Collections.emptyMap();

    @Override
    public Set<String> getRoles(String identification) {
        Set<String> set = this.users.get(identification);
        return set != null ? set : Collections.emptySet();
    }

    @Override
    public boolean isUserInRole(String identification, String role) {
        Set<String> roles = this.getRoles(identification);
        return roles != null && roles.contains(role);
    }

    @Override
    public Set<String> getUsers(String role) {
        Set<String> set = this.roles.get(role);
        return set != null ? set : Collections.emptySet();
    }

    @Override
    public String getAppAdminEmail() {
        return this.getSingleUser("mail");
    }

    @Override
    public String getAppDevEmail() {
        return this.getSingleUser("dev");
    }

    protected String getSingleUser(String role) {
        Set<String> strings = this.getUsers(role);
        if (strings.isEmpty()) {
            throw new IllegalArgumentException("No matches for " + role + ", illegal admin.properties: " + this.users);
        }
        return strings.iterator().next();
    }

    @Inject
    public void setPropertes(@Resource(value="admin.properties") Properties props) {
        this.users = new HashMap<String, Set<String>>();
        this.roles = new HashMap<String, Set<String>>();
        for (String key : props.stringPropertyNames()) {
            String[] split = props.getProperty(key).split(",");
            this.users.put(key, new HashSet<String>(Arrays.asList(split)));
            for (String role : split) {
                Set<String> set = this.roles.get(role);
                if (set == null) {
                    set = new TreeSet<String>();
                    this.roles.put(role, set);
                }
                set.add(key);
            }
        }
    }
}

