/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.capedwarf.server.api.io.BaseBlobService;
import org.jboss.capedwarf.server.api.io.Blob;

public abstract class AbstractBlobService
extends BaseBlobService {
    public Blob toBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.toBlobInternal(bytes);
    }

    protected abstract Blob toBlobInternal(byte[] var1);

    public byte[] loadBytes(String key, long startIndex, long endIndex) {
        if (key == null || startIndex > endIndex) {
            return null;
        }
        if (startIndex == endIndex) {
            return new byte[0];
        }
        return this.loadBytesInternal(key, startIndex, endIndex);
    }

    protected abstract byte[] loadBytesInternal(String var1, long var2, long var4);

    public String storeBytes(String mimeType, byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return this.storeBytesInternal(mimeType, ByteBuffer.wrap(bytes));
    }

    public String storeBytes(String mimeType, ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            return null;
        }
        return this.storeBytesInternal(mimeType, buffer);
    }

    protected abstract String storeBytesInternal(String var1, ByteBuffer var2) throws IOException;
}

