/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.tx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransactionPropagationType {
    REQUIRED,
    REQUIRES_NEW,
    MANDATORY,
    SUPPORTS,
    NOT_SUPPORTED,
    NEVER;


    public boolean isNewTransactionRequired(boolean transactionActive) {
        switch (this) {
            case REQUIRED: {
                return !transactionActive;
            }
            case REQUIRES_NEW: {
                return true;
            }
            case SUPPORTS: {
                return false;
            }
            case MANDATORY: {
                if (!transactionActive) {
                    throw new IllegalStateException("No transaction active on call to MANDATORY method");
                }
                return false;
            }
            case NOT_SUPPORTED: 
            case NEVER: {
                if (transactionActive) {
                    throw new IllegalStateException("Transaction active on call to NEVER method");
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }
}

