/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.tx;

import javax.persistence.EntityTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Work<T> {
    protected abstract T work() throws Exception;

    protected boolean isNewTransactionRequired(boolean transactionActive) {
        return !transactionActive;
    }

    public final T workInTransaction(EntityTransaction transaction) throws Exception {
        EntityTransaction userTransaction;
        boolean newTransactionRequired = this.isNewTransactionRequired(transaction.isActive());
        Object object = userTransaction = newTransactionRequired ? transaction : null;
        if (newTransactionRequired) {
            userTransaction.begin();
        }
        try {
            T result = this.work();
            if (newTransactionRequired) {
                if (transaction.getRollbackOnly()) {
                    userTransaction.rollback();
                } else {
                    userTransaction.commit();
                }
            }
            return result;
        }
        catch (Exception e) {
            T fallback = this.handleException(e);
            if (newTransactionRequired && fallback == null && userTransaction.isActive()) {
                try {
                    userTransaction.rollback();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (fallback == null) {
                throw e;
            }
            return fallback;
        }
    }

    protected T handleException(Exception e) {
        return null;
    }
}

