/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import org.jboss.capedwarf.server.api.io.BaseBlobService;
import org.jboss.capedwarf.server.api.io.BlobCache;
import org.jboss.capedwarf.server.api.io.BlobService;

@Decorator
public abstract class CachedBlobService
extends BaseBlobService {
    private BlobService delegate;
    private BlobCache cache;

    public byte[] loadBytes(String key, long startIndex, long endIndex) {
        byte[] cached = this.cache.get(key);
        if (cached != null) {
            return cached;
        }
        byte[] bytes = this.delegate.loadBytes(key, startIndex, endIndex);
        this.cache.put(key, bytes);
        return bytes;
    }

    public String storeBytes(String mimeType, ByteBuffer buffer) throws IOException {
        String key = this.delegate.storeBytes(mimeType, buffer);
        this.cache.put(key, buffer.array());
        return key;
    }

    @Inject
    public void setDelegate(@Delegate BlobService delegate) {
        this.delegate = delegate;
    }

    @Inject
    public void setCache(BlobCache cache) {
        this.cache = cache;
    }
}

