/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.servlet;

import java.util.ServiceLoader;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import org.jboss.capedwarf.server.api.servlet.BeanManagerLookup;

public class BeanManagerUtils {
    private static final String BM_KEY = "org.jboss.weld.environment.servlet." + BeanManager.class.getName();

    public static BeanManager lookup(ServletContext context) {
        BeanManager manager = (BeanManager)context.getAttribute(BeanManagerUtils.class.getName());
        if (manager != null) {
            return manager;
        }
        manager = BeanManagerUtils.doLookup(context);
        context.setAttribute(BeanManagerUtils.class.getName(), (Object)manager);
        return manager;
    }

    protected static BeanManager doLookup(ServletContext context) {
        ServiceLoader<BeanManagerLookup> bmls = ServiceLoader.load(BeanManagerLookup.class, BeanManagerUtils.class.getClassLoader());
        for (BeanManagerLookup bml : bmls) {
            BeanManager manager = bml.lookup(context);
            if (manager == null) continue;
            return manager;
        }
        BeanManager manager = (BeanManager)context.getAttribute(BM_KEY);
        if (manager == null) {
            throw new IllegalArgumentException("No Weld manager present");
        }
        return manager;
    }
}

