/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.dao.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jboss.capedwarf.jpa.ProxyingEnum;
import org.jboss.capedwarf.server.api.dao.GenericDAO;
import org.jboss.capedwarf.server.api.dao.StatelessDAO;
import org.jboss.capedwarf.server.api.dao.impl.StatelessAdapter2DAOBridge;
import org.jboss.capedwarf.server.api.domain.AbstractEntity;
import org.jboss.capedwarf.server.api.persistence.EMInjector;
import org.jboss.capedwarf.server.api.persistence.Proxying;
import org.jboss.capedwarf.server.api.persistence.StatelessAdapterFactory;
import org.jboss.capedwarf.server.api.tx.TransactionPropagationType;
import org.jboss.capedwarf.server.api.tx.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public abstract class AbstractGenericDAO<T extends AbstractEntity>
implements GenericDAO<T> {
    private EMInjector emInjector;
    private StatelessAdapterFactory statelessAdapterFactory;

    @Inject
    public void setEmInjector(EMInjector emInjector) {
        this.emInjector = emInjector;
    }

    @Inject
    public void setStatelessAdapterFactory(StatelessAdapterFactory statelessAdapterFactory) {
        this.statelessAdapterFactory = statelessAdapterFactory;
    }

    protected abstract Class<T> entityClass();

    protected EntityManager getEM() {
        return this.emInjector.getEM();
    }

    protected T getSingleResult(Query query) {
        List result = query.getResultList();
        return this.getSingleResult(result);
    }

    protected T getSingleResult(Collection result) {
        return (T)(result.isEmpty() ? null : (AbstractEntity)result.iterator().next());
    }

    protected Long getSingleId(Query query) {
        List result = query.getResultList();
        return result.isEmpty() ? null : Long.valueOf(((Number)result.get(0)).longValue());
    }

    protected String getSingleString(Query query) {
        List result = query.getResultList();
        return result.isEmpty() ? null : result.get(0).toString();
    }

    protected Long getCount(Query query) {
        Object result = query.getSingleResult();
        return ((Number)result).longValue();
    }

    protected boolean idExists(Query query) {
        return this.exists(this.getSingleId(query));
    }

    protected boolean exists(Object value) {
        return value != null;
    }

    @Override
    @Transactional
    public void save(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity");
        }
        this.saveInternal(entity);
    }

    protected void saveInternal(T entity) {
        this.getEM().persist(entity);
    }

    @Override
    @Transactional
    public void merge(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity");
        }
        this.getEM().merge(entity);
    }

    @Override
    @Proxying(value=ProxyingEnum.DISABLE)
    @Transactional
    public int delete(Long id) {
        if (id == null || id <= 0L) {
            throw new IllegalArgumentException("Illegal id: " + id);
        }
        Query query = this.getEM().createQuery("delete from " + this.entityClass().getSimpleName() + " e where e.id = :eid");
        query.setParameter("eid", (Object)id);
        return query.executeUpdate();
    }

    @Override
    @Transactional
    public void delete(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity");
        }
        this.getEM().remove(entity);
    }

    @Override
    @Transactional(value=TransactionPropagationType.SUPPORTS)
    public T find(Long id) {
        return (T)((AbstractEntity)this.find(this.entityClass(), id));
    }

    @Override
    @Transactional(value=TransactionPropagationType.SUPPORTS)
    public <U> U find(Class<U> clazz, Long id) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        if (id == null) {
            throw new IllegalArgumentException("Null id");
        }
        return (U)this.getEM().find(clazz, (Object)id);
    }

    @Override
    @Transactional(value=TransactionPropagationType.SUPPORTS)
    public List<T> findAll() {
        EntityManager em = this.getEM();
        Query query = em.createQuery("select e from " + this.entityClass().getSimpleName() + " e");
        return query.getResultList();
    }

    @Override
    @Transactional(value=TransactionPropagationType.REQUIRED)
    @Proxying(value=ProxyingEnum.DISABLE)
    public StatelessDAO<T> statelessView(final boolean autoClose) {
        return (StatelessDAO)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{StatelessDAO.class}, new InvocationHandler(){
            private StatelessDAO<T> delegate;

            private synchronized StatelessDAO<T> getDelegate() {
                if (this.delegate == null) {
                    this.delegate = new StatelessAdapter2DAOBridge(AbstractGenericDAO.this.statelessAdapterFactory.createStatelessAdapter(AbstractGenericDAO.this.getEM()));
                }
                return this.delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                StatelessDAO bridge = this.getDelegate();
                try {
                    Object object = method.invoke(bridge, args);
                    return object;
                }
                finally {
                    if (autoClose) {
                        bridge.close();
                    }
                }
            }
        });
    }
}

