/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.domain;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.persistence.Embeddable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Embeddable
public class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = ".";
    private static final String PATTERN = "[a-zA-Z0-9_-]*";
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("[a-zA-Z0-9_-]*");
    public static final Version DEFAULT_VERSION = new Version(0, 0, 0);
    private int major;
    private int minor;
    private int micro;
    private String qualifier;

    public Version() {
    }

    public static Version valueOf(String string) {
        return Version.parseVersion(string);
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        if (qualifier == null) {
            qualifier = "";
        }
        this.qualifier = qualifier;
        this.validate();
    }

    private Version(String version) {
        int major;
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            major = Integer.parseInt(st.nextToken().trim());
            if (st.hasMoreTokens()) {
                st.nextToken();
                minor = Integer.parseInt(st.nextToken().trim());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    micro = Integer.parseInt(st.nextToken().trim());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        qualifier = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("Invalid version format, too many seperators: " + version);
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid version format: " + version);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version format: " + version, e);
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.validate();
    }

    protected void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("negative major: " + this.major);
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("negative minor: " + this.minor);
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("negative micro: " + this.micro);
        }
        if (!QUALIFIER_PATTERN.matcher(this.qualifier).matches()) {
            throw new IllegalArgumentException("Invalid qualifier, it must be [a-zA-Z0-9_-]*: " + this.qualifier);
        }
    }

    public static Version parseVersion(String version) {
        if (version == null) {
            return DEFAULT_VERSION;
        }
        if ((version = version.trim()).length() == 0) {
            return DEFAULT_VERSION;
        }
        return new Version(version);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public void setMicro(int micro) {
        this.micro = micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major).append(SEPARATOR).append(this.minor).append(SEPARATOR).append(this.micro);
        if (this.qualifier.length() > 0) {
            builder.append(SEPARATOR).append(this.qualifier);
        }
        return builder.toString();
    }

    public int hashCode() {
        return (this.major << 24) + (this.minor << 16) + (this.micro << 8) + this.qualifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        int result = this.major - version.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - version.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - version.micro;
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(version.qualifier);
    }
}

