/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.env;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.transaction.UserTransaction;
import javax.validation.ValidatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvExtension
implements Extension {
    private static final Set<Class<?>> builtInBeanTypes = new HashSet();
    private static final Set<String> gaeBeans;
    private Boolean isGAE;

    protected boolean isGAE() {
        if (this.isGAE == null) {
            this.isGAE = System.getProperty("jboss.home.dir") == null;
        }
        return this.isGAE;
    }

    protected boolean isBuiltInType(Class<?> clazz) {
        for (Class<?> bibt : builtInBeanTypes) {
            if (!bibt.isAssignableFrom(clazz)) continue;
            return true;
        }
        String className = clazz.getName();
        for (String gb : gaeBeans) {
            if (!gb.equals(className)) continue;
            return true;
        }
        return false;
    }

    public void processBeans(@Observes ProcessAnnotatedType pat) {
        AnnotatedType annotatedType;
        if (!this.isGAE() && this.isBuiltInType((annotatedType = pat.getAnnotatedType()).getJavaClass())) {
            pat.veto();
        }
    }

    static {
        builtInBeanTypes.add(BeanManager.class);
        builtInBeanTypes.add(ValidatorFactory.class);
        builtInBeanTypes.add(UserTransaction.class);
        gaeBeans = new HashSet<String>();
        gaeBeans.add("org.jboss.capedwarf.server.gae.validation.CdiValidationFactoryProvider");
    }
}

