/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.io.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.capedwarf.server.api.io.ResourceReader;
import org.jboss.seam.solder.resourceLoader.Resource;

@ApplicationScoped
public class ClassLoaderResourceReader
implements ResourceReader {
    @Produces
    @Resource(value="")
    public byte[] getResource(InjectionPoint ip) {
        return this.getResource(this.getName(ip));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getResource(String resource) {
        byte[] byArray;
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = cl.getResource(resource);
        if (url == null) {
            return null;
        }
        InputStream is = url.openStream();
        try {
            int b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = is.read()) >= 0) {
                baos.write(b);
            }
            baos.flush();
            baos.close();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        is.close();
        return byArray;
    }

    private String getName(InjectionPoint ip) {
        Set qualifiers = ip.getQualifiers();
        for (Annotation qualifier : qualifiers) {
            if (!qualifier.annotationType().equals(Resource.class)) continue;
            return ((Resource)qualifier).value();
        }
        throw new IllegalArgumentException("Injection point " + ip + " does not have @Resource qualifier");
    }
}

