/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.persistence;

import java.io.Serializable;
import org.jboss.capedwarf.server.api.persistence.StatelessAdapter;

final class TupleHolder {
    private static ThreadLocal<Tuple> tl = new ThreadLocal();

    TupleHolder() {
    }

    static Tuple get() {
        Tuple tuple = tl.get();
        if (tuple != null) {
            tuple.count++;
        }
        return tuple;
    }

    static Tuple create(StatelessAdapter adapter) {
        Tuple tuple = new Tuple();
        tuple.adapter = new StatelessAdapterWrapper(adapter);
        tuple.count = 1;
        tl.set(tuple);
        return tuple;
    }

    static void close() {
        Tuple tuple = tl.get();
        if (tuple == null) {
            throw new IllegalStateException("No tuple!");
        }
        tuple.count--;
        if (tuple.count == 0) {
            tl.remove();
            tuple.adapter.doClose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatelessAdapterWrapper
    implements StatelessAdapter {
        private final StatelessAdapter delegate;

        private StatelessAdapterWrapper(StatelessAdapter delegate) {
            this.delegate = delegate;
        }

        void doClose() {
            this.delegate.close();
        }

        @Override
        public void close() {
            TupleHolder.close();
        }

        @Override
        public Long insert(Object entity) {
            return this.delegate.insert(entity);
        }

        @Override
        public void update(Object entity) {
            this.delegate.update(entity);
        }

        @Override
        public void delete(Object entity) {
            this.delegate.delete(entity);
        }

        @Override
        public <T> T get(Class<T> entityClass, Serializable id) {
            return this.delegate.get(entityClass, id);
        }

        @Override
        public void refresh(Object entity) {
            this.delegate.refresh(entity);
        }

        @Override
        public void initialize(Object proxy) {
            this.delegate.initialize(proxy);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static class Tuple {
        private StatelessAdapterWrapper adapter;
        private int count;

        Tuple() {
        }

        StatelessAdapter getAdapter() {
            return this.adapter;
        }
    }
}

