/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.cache;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.capedwarf.server.api.cache.CacheConfig;
import org.jboss.capedwarf.server.api.cache.CacheExceptionHandler;
import org.jboss.capedwarf.server.api.cache.CacheMode;
import org.jboss.capedwarf.server.api.cache.Cacheable;
import org.jboss.capedwarf.server.api.cache.KeyStrategy;

@Cacheable
@Interceptor
public class CacheInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CacheInterceptor.class.getName());
    private static Map<Class<? extends KeyStrategy>, KeyStrategy> keys = new ConcurrentHashMap<Class<? extends KeyStrategy>, KeyStrategy>();
    private transient CacheConfig cacheConfig;
    private transient CacheExceptionHandler exceptionHandler;

    @AroundInvoke
    public Object manageCache(InvocationContext ctx) throws Exception {
        Class<?> clazz = ctx.getTarget().getClass();
        Method m = ctx.getMethod();
        Cacheable cacheable = m.getAnnotation(Cacheable.class);
        if (cacheable == null) {
            cacheable = clazz.getAnnotation(Cacheable.class);
        }
        if (cacheable == null) {
            throw new IllegalArgumentException("Null cachable, invalid usage?");
        }
        String cacheName = cacheable.name();
        Cache cache = this.cacheConfig.configureCache(cacheName);
        CacheMode mode = cacheable.mode();
        Class<? extends KeyStrategy> ksClass = cacheable.key();
        KeyStrategy ks = keys.get(ksClass);
        if (ks == null) {
            try {
                ks = ksClass.newInstance();
            }
            catch (Exception e) {
                log.fine("Error creating KeyStrategy: " + e);
                Constructor<? extends KeyStrategy> ctor = ksClass.getConstructor(CacheConfig.class);
                ks = ctor.newInstance(this.cacheConfig);
            }
            keys.put(ksClass, ks);
        }
        Object target = ctx.getTarget();
        Object[] args = ctx.getParameters();
        Serializable key = ks.createKey(target, m, args);
        Object value = null;
        try {
            Object unwraped;
            if (mode == CacheMode.READ_ONLY || mode == CacheMode.ALL) {
                value = cache.get((Object)key);
            }
            if (value != null && (unwraped = ks.unwrap(value, target, m, args)) != null) {
                return unwraped;
            }
            value = ctx.proceed();
            if (value != null && (mode == CacheMode.WRITE_ONLY || mode == CacheMode.ALL)) {
                cache.put((Object)key, ks.wrap(value, target, m, args));
            } else if (mode == CacheMode.REMOVE) {
                cache.remove((Object)key);
            } else if (mode == CacheMode.EVICT) {
                cache.evict();
            } else if (mode == CacheMode.CLEAR) {
                cache.clear();
            }
            return value;
        }
        catch (Throwable e) {
            return this.exceptionHandler.handleException(cache, ctx, key, value, e);
        }
    }

    @Inject
    public void setExceptionHandler(CacheExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Inject
    public void setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }
}

