/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.io.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.capedwarf.server.api.dao.ImageDAO;
import org.jboss.capedwarf.server.api.domain.AbstractEntity;
import org.jboss.capedwarf.server.api.domain.AbstractImage;
import org.jboss.capedwarf.server.api.io.AbstractSimpleBlobService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public abstract class AbstractDatabaseBlobService<T extends AbstractImage>
extends AbstractSimpleBlobService {
    private ImageDAO<T> imageDAO;

    @Override
    protected byte[] loadBytesInternal(String key, long startIndex, long endIndex) {
        Long id = Long.parseLong(key);
        AbstractImage image = (AbstractImage)this.imageDAO.find(id);
        if (image != null) {
            long min = endIndex == Long.MAX_VALUE ? image.getLength() : endIndex;
            try {
                return image.read(startIndex, min);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected abstract T createImageInstance();

    @Override
    protected String storeBytesInternal(String mimeType, ByteBuffer buffer) throws IOException {
        try {
            T image = this.createImageInstance();
            ((AbstractImage)image).setMimeType(mimeType);
            byte[] array = buffer.array();
            ((AbstractImage)image).write(array);
            ((AbstractImage)image).setLength(array.length);
            this.imageDAO.save(image);
            return Long.toString(((AbstractEntity)image).getId());
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Inject
    public void setImageDAO(ImageDAO<T> imageDAO) {
        this.imageDAO = imageDAO;
    }
}

