/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.server.api.servlet.BeanManagerUtils;
import org.jboss.capedwarf.server.api.servlet.FilterHandler;
import org.jboss.capedwarf.server.api.servlet.RequestHandler;

public class WeldServlet
extends HttpServlet
implements Filter {
    private static String REQUEST_HANDLER = "request-handler";
    private RequestHandler handler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        String wrapperClass = config.getInitParameter(REQUEST_HANDLER);
        this.init(context, wrapperClass);
    }

    private void init(ServletContext context, String wrapperClass) throws ServletException {
        if (wrapperClass == null) {
            throw new IllegalArgumentException("Missing handler class parameter");
        }
        BeanManager manager = BeanManagerUtils.lookup(context);
        try {
            ClassLoader cl = RequestHandler.class.getClassLoader();
            Class<?> tmp = cl.loadClass(wrapperClass);
            if (!RequestHandler.class.isAssignableFrom(tmp)) {
                throw new ServletException("Illegal handler class, wrong type: " + tmp);
            }
            Class<?> clazz = tmp;
            InjectionTarget it = manager.createInjectionTarget(manager.createAnnotatedType(clazz));
            CreationalContext cc = manager.createCreationalContext(null);
            this.handler = (RequestHandler)it.produce(cc);
            it.inject((Object)this.handler, cc);
            this.handler.initialize(context);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        String wrapperClass = config.getInitParameter(REQUEST_HANDLER);
        this.init(context, wrapperClass);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            if (this.handler instanceof FilterHandler) {
                FilterHandler fh = (FilterHandler)((Object)this.handler);
                if (!fh.accepts((HttpServletRequest)request, (HttpServletResponse)response)) {
                    return;
                }
            } else {
                this.handle((HttpServletRequest)request, (HttpServletResponse)response);
            }
            chain.doFilter(request, response);
        } else {
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write("ERROR -- can only handle Http requests / response.");
            ((Writer)writer).flush();
        }
    }

    protected final void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handler.handle(req, resp);
    }
}

