/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.common.serialization.GzipOptionalSerializator;
import org.jboss.capedwarf.server.api.io.Blob;
import org.jboss.capedwarf.server.api.io.BlobService;

public abstract class AbstractBlobService
implements BlobService {
    public Blob toBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.toBlobInternal(bytes);
    }

    protected abstract Blob toBlobInternal(byte[] var1);

    public byte[] loadBytes(String key) {
        return this.loadBytes(key, 0L, Long.MAX_VALUE);
    }

    public byte[] loadBytes(String key, long startIndex, long endIndex) {
        if (key == null || startIndex > endIndex) {
            return null;
        }
        if (startIndex == endIndex) {
            return new byte[0];
        }
        return this.loadBytesInternal(key, startIndex, endIndex);
    }

    protected abstract byte[] loadBytesInternal(String var1, long var2, long var4);

    public void serveBytes(String key, OutputStream outstream) throws IOException {
        this.serveBytes(key, 0L, outstream);
    }

    public void serveBytes(String key, long start, OutputStream outstream) throws IOException {
        this.serveBytes(key, start, Long.MAX_VALUE, outstream);
    }

    public void serveBytes(String key, long start, long end, OutputStream outstream) throws IOException {
        byte[] bytes = this.loadBytes(key, start, end);
        if (bytes != null) {
            if (GzipOptionalSerializator.isGzipDisabled()) {
                outstream.write(bytes);
            } else {
                GZIPOutputStream gzip = new GZIPOutputStream(outstream);
                gzip.write(bytes);
                gzip.finish();
            }
        }
    }

    public void serveBytes(String key, long start, long end, HttpServletResponse respose) throws IOException {
        this.serveBytes(key, start, end, (OutputStream)respose.getOutputStream());
    }

    public String storeBytes(String mimeType, byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return this.storeBytesInternal(mimeType, ByteBuffer.wrap(bytes));
    }

    public String storeBytes(String mimeType, ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            return null;
        }
        return this.storeBytesInternal(mimeType, buffer);
    }

    protected abstract String storeBytesInternal(String var1, ByteBuffer var2) throws IOException;
}

