/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.mvc;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.server.api.servlet.AbstractRequestHandler;
import org.jboss.capedwarf.server.api.servlet.RequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public abstract class ActionController
extends AbstractRequestHandler {
    private ServletContext context;
    private BeanManager beanManager;
    private Map<String, RequestHandler> actions = Collections.emptyMap();
    private Map<String, Class> classes = Collections.emptyMap();

    @Inject
    public void setBeanManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    @Override
    protected void doInitialize(ServletContext context) {
        this.context = context;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String actionName = req.getParameter("action");
        if (actionName != null) {
            Class ac;
            RequestHandler action = this.actions.get(actionName);
            if (action == null && (ac = this.classes.get(actionName)) != null) {
                if (this.beanManager == null) {
                    throw new IllegalArgumentException("No Weld manager present");
                }
                InjectionTarget it = this.beanManager.createInjectionTarget(this.beanManager.createAnnotatedType(ac));
                CreationalContext cc = this.beanManager.createCreationalContext(null);
                action = (RequestHandler)it.produce(cc);
                it.inject((Object)action, cc);
                action.initialize(this.context);
                this.actions.put(actionName, action);
            }
            if (action != null) {
                action.handle(req, resp);
            } else {
                throw new ServletException("No such matching action: " + actionName);
            }
        }
    }

    protected void addActionClass(String name, Class<? extends RequestHandler> clazz) {
        if (this.classes.isEmpty()) {
            this.classes = new HashMap<String, Class>();
        }
        this.classes.put(name, clazz);
    }

    protected void addAction(String name, RequestHandler handler) {
        if (this.actions.isEmpty()) {
            this.actions = new HashMap<String, RequestHandler>();
        }
        this.actions.put(name, handler);
    }
}

