/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.dao.impl;

import javax.inject.Inject;
import org.jboss.capedwarf.server.api.dao.TimestampedDAO;
import org.jboss.capedwarf.server.api.dao.impl.AbstractGenericDAO;
import org.jboss.capedwarf.server.api.domain.TimestampedEntity;
import org.jboss.capedwarf.server.api.tx.TransactionPropagationType;
import org.jboss.capedwarf.server.api.tx.Transactional;
import org.jboss.capedwarf.server.api.utils.TimestampProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTimestampedDAO<T extends TimestampedEntity>
extends AbstractGenericDAO<T>
implements TimestampedDAO<T> {
    private TimestampProvider tp;

    protected long currentTimestamp() {
        return this.tp.currentTimeMillis();
    }

    @Override
    protected void saveInternal(T entity) {
        long ts = this.tp.currentTimeMillis();
        ((TimestampedEntity)entity).setTimestamp(ts);
        ((TimestampedEntity)entity).setExpirationTime(((TimestampedEntity)entity).getExpirationTime() + ts);
        super.saveInternal(entity);
    }

    @Override
    @Transactional(value=TransactionPropagationType.SUPPORTS)
    public boolean hasExpired(T entity) {
        if (entity == null) {
            return true;
        }
        long expirationTime = ((TimestampedEntity)entity).getExpirationTime();
        return expirationTime > this.tp.currentTimeMillis();
    }

    @Inject
    public void setTp(TimestampProvider tp) {
        this.tp = tp;
    }
}

