/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.mvc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.jboss.capedwarf.common.dto.DTOModel;
import org.jboss.capedwarf.common.serialization.GzipOptionalSerializator;
import org.jboss.capedwarf.common.serialization.Serializator;
import org.jboss.capedwarf.server.api.mvc.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionsAction<T extends Serializable>
extends AbstractAction {
    private Serializator serializator;

    @Override
    protected void doInitialize(ServletContext context) {
        super.doInitialize(context);
        this.serializator = new GzipOptionalSerializator(this.getSerializator());
    }

    protected abstract Serializator getSerializator();

    protected abstract DTOModel<T> getDtoModel();

    protected void toDTO(Iterable<T> elements, HttpServletResponse resp) throws IOException {
        try {
            ArrayList<Object> dtos = new ArrayList<Object>();
            for (Serializable t : elements) {
                Object dto = this.getDtoModel().toDTO(t);
                dtos.add(dto);
            }
            this.prepareResponse(resp);
            this.serializator.serialize(dtos, (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Error handling collections.", e);
            resp.sendError(303);
        }
    }
}

