/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.api.ui;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.cache.Cache;
import javax.cache.CacheStatistics;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.capedwarf.server.api.cache.CacheConfig;
import org.jboss.capedwarf.server.api.security.Security;
import org.jboss.capedwarf.server.api.ui.CacheEntry;
import org.jboss.capedwarf.server.api.ui.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="cc")
@ConversationScoped
public class CacheCommand
extends Command
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient CacheConfig cacheConfig;
    private List<CacheEntry> entries = Collections.emptyList();

    public List<CacheEntry> getEntries() {
        return this.entries;
    }

    public int getSize() {
        return this.entries.size();
    }

    protected void display(Object key, Object value) {
        this.entries = Collections.singletonList(new CacheEntry(key, value));
    }

    protected String getName(String form) {
        return this.getParameter(form, "cacheName");
    }

    @Security
    public void evictCache() {
        String name = this.getName("evict");
        this.display("Evict: " + name, this.cacheConfig.evictCache(name));
    }

    @Security
    public void clearCache() {
        String name = this.getName("clear");
        this.display("Clear: " + name, this.cacheConfig.clearCache(name));
    }

    @Security
    public void executeCache() {
        String execute = this.getParameter("execute", "args");
        String[] split = execute.split(",");
        if (split.length != 3) {
            throw new IllegalArgumentException("Illegal execute args: " + execute);
        }
        String name = split[0];
        Cache cache = this.cacheConfig.findCache(name);
        if (cache != null) {
            Object key;
            String op = split[1];
            try {
                key = Long.parseLong(split[2]);
            }
            catch (Throwable ignored) {
                key = split[2];
            }
            if ("get".equals(op)) {
                this.display(key, cache.get(key));
            } else if ("getCacheEntry".equals(op)) {
                this.display(key, cache.getCacheEntry(key));
            } else if ("peek".equals(op)) {
                this.display(key, cache.peek(key));
            } else if ("remove".equals(op)) {
                this.display(key, cache.remove(key));
            } else if ("size".equals(op)) {
                this.display("Size: ", cache.size());
            }
        } else {
            this.display("", "No such cache:" + name);
        }
    }

    @Security
    public void statsCache() throws Exception {
        String execute = this.getParameter("stats", "args");
        String[] split = execute.split(",");
        if (split.length != 2) {
            throw new IllegalArgumentException("Illegal stats args: " + execute);
        }
        String name = split[0];
        Cache cache = this.cacheConfig.findCache(name);
        if (cache != null) {
            CacheStatistics stats = cache.getCacheStatistics();
            String op = split[1];
            Method m = CacheStatistics.class.getMethod(op, new Class[0]);
            this.display(op, m.invoke((Object)stats, new Object[0]));
        } else {
            this.display("", "No such cache:" + name);
        }
    }

    @Inject
    public void setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }
}

