/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.jee.env.impl;

import java.util.logging.Logger;
import javax.mail.Session;
import javax.transaction.TransactionManager;
import org.jboss.capedwarf.server.jee.env.impl.AbstractEnvironment;

public class GenericEnvironment
extends AbstractEnvironment {
    private static Logger log = Logger.getLogger(GenericEnvironment.class.getName());
    private static String[][] knownJNDIManagers = new String[][]{{"java:/TransactionManager", "JBoss"}, {"java:appserver/TransactionManager", "Glassfish"}, {"javax.transaction.TransactionManager", "BEA WebLogic"}, {"java:comp/UserTransaction", "Resin, Orion, JOnAS (JOTM)"}};

    public TransactionManager lookupTxManager() throws Exception {
        for (String[] jndiManagerName : knownJNDIManagers) {
            try {
                TransactionManager tm = GenericEnvironment.doLookup(jndiManagerName[0], TransactionManager.class);
                log.info("Found Tx manager for " + jndiManagerName[1]);
                return tm;
            }
            catch (Exception ignored) {
            }
        }
        throw new IllegalArgumentException("No Tx manager found!");
    }

    public Session lookupMailSession() throws Exception {
        return GenericEnvironment.doLookup(true, Session.class, "java:/Mail", "mail/Session");
    }
}

