/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.jee.persistence;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.jboss.capedwarf.server.api.persistence.AbstractStatelessAdapterFactory;
import org.jboss.capedwarf.server.api.persistence.StatelessAdapter;

@ApplicationScoped
public class HibernateStatelessAdapterFactory
extends AbstractStatelessAdapterFactory {
    protected StatelessAdapter doCreateStatelessAdapter(EntityManager em) {
        Object delegate = em.getDelegate();
        if (!(delegate instanceof Session)) {
            throw new IllegalArgumentException("Can only handle Hibernate Session: " + delegate);
        }
        Session session = (Session)delegate;
        SessionFactory factory = session.getSessionFactory();
        return new HibernateStatelessAdapter(factory.openStatelessSession());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HibernateStatelessAdapter
    implements StatelessAdapter {
        private final StatelessSession session;

        private HibernateStatelessAdapter(StatelessSession session) {
            this.session = session;
        }

        public Long insert(Object entity) {
            return (Long)this.session.insert(entity);
        }

        public void update(Object entity) {
            this.session.update(entity);
        }

        public void delete(Object entity) {
            this.session.delete(entity);
        }

        public <T> T get(Class<T> entityClass, Serializable id) {
            if (entityClass == null) {
                throw new IllegalArgumentException("Null entity class!");
            }
            return entityClass.cast(this.session.get(entityClass, id));
        }

        public void refresh(Object entity) {
            this.session.refresh(entity);
        }

        public void close() {
            this.session.close();
        }

        public void initialize(Object proxy) {
            Hibernate.initialize((Object)proxy);
        }
    }
}

